//                                               -*- C++ -*-
/**
 *  @file  ComparisonOperator.cxx
 *  @brief Abstract top-level class for all ComparisonOperator
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: ComparisonOperator.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "ComparisonOperator.hxx"
#include "Less.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(ComparisonOperator);

      /* Default constructor */
      ComparisonOperator::ComparisonOperator()
	: TypedInterfaceObject<ComparisonOperatorImplementation>(new Less)
      {
	// Nothing to do
      }


      /* Constructor from implementation */
      ComparisonOperator::ComparisonOperator(const ComparisonOperatorImplementation & op)
	: TypedInterfaceObject<ComparisonOperatorImplementation>(op.clone())
      {
	// Nothing to do
      }


      /* Return true if comparison succeeds */
      Bool ComparisonOperator::operator()(NumericalScalar a, NumericalScalar b) const
      {
	return (*getImplementation())(a,b);
      }
      Bool ComparisonOperator::compare(NumericalScalar a, NumericalScalar b) const
      {
	return (*getImplementation())(a,b);
      }




    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
