//                                               -*- C++ -*-
/**
 *  @file  Exception.cxx
 *  @brief Exception defines top-most exception strategies
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-29 18:54:45 +0100 (mer 29 oct 2008) $
 *  Id:      $Id: Exception.cxx 990 2008-10-29 17:54:45Z dutka $
 */
#include <cstdlib>
#include <assert.h>
#include "OSS.hxx"
#include "Exception.hxx"
#include "Log.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      ExceptionNames * ExceptionNames::p_instance = 0;



      ExceptionNames::ExceptionNames()
	: names_()
      {
	Log::Debug("ExceptionNames ctor");
	
	// Registration of destructor at exit
	int rc = std::atexit(ExceptionNames::release);

	Log::Debug(OSS() << "ExceptionNames registration of destructor = " << (rc ? "ERROR" : "OK") );

	std::vector<String> & ref_names_ = *static_cast<std::vector<String> *>(&names_);
	ref_names_.push_back("FileNotFoundException");
	ref_names_.push_back("InternalException");
	ref_names_.push_back("InvalidArgumentException");
	ref_names_.push_back("InvalidDimensionException");
	ref_names_.push_back("NoWrapperFileFoundException");
	ref_names_.push_back("NotYetImplementedException");
	ref_names_.push_back("OutOfBoundException");
	ref_names_.push_back("WrapperFileParsingException");
	ref_names_.push_back("WrapperInternalException");
	ref_names_.push_back("XMLException");
	ref_names_.push_back("XMLParserException");
	ref_names_.push_back("DynamicLibraryException");
	ref_names_.push_back("NotSymmetricDefinitePositiveException");
	ref_names_.push_back("InvalidRangeException");
	ref_names_.push_back("NotDefinedException");
	ref_names_.push_back("NetworkException");
	ref_names_.push_back("RException");
	ref_names_.push_back("FileOpenException");
	ref_names_.push_back("StudyFileParsingException");
	ref_names_.push_back("ObjectNotInStudyException");
	ref_names_.push_back("ConfigurationFileParsingException");
      }


      ExceptionNames::~ExceptionNames()
      {
	Log::Debug("ExceptionNames dtor");
      }


      const String ExceptionNames::get(unsigned int id)
      {
	if (!p_instance) p_instance = new ExceptionNames;
	assert(p_instance != 0);
	assert( (id >= 0) && (id < p_instance->names_.size()) );
	return p_instance->names_[id];
      }


      void ExceptionNames::release()
      {
	delete p_instance;
	p_instance = 0;
      }


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
