//                                               -*- C++ -*-
/**
 *  @file  PersistentObject.cxx
 *  @brief Class PersistentObject saves and reloads the object's internal state
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-24 12:02:17 +0200 (jeu 24 mai 2007) $
 *  Id:      $Id: PersistentObject.cxx 446 2007-05-24 10:02:17Z dutka $
 */
#include "PersistentObject.hxx"
#include "OTconfig.hxx"

namespace OpenTURNS
{

  /*
   * The default name of any object
   */
  const String DefaultName = String(
#ifdef OBJECT_DEFAULT_NAME
  OBJECT_DEFAULT_NAME
#else
  "Unnamed (hard coded in PersistentObject.cxx)"
#endif
  );

  namespace Base
  {

    namespace Common
    {

      CLASSNAMEINIT(PersistentObject);

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
