//                                               -*- C++ -*-
/**
 *  @file  PlatformInfo.cxx
 *  @brief The class PlatformInfo gives information about the library
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-29 18:54:45 +0100 (mer 29 oct 2008) $
 *  Id:      $Id: PlatformInfo.cxx 990 2008-10-29 17:54:45Z dutka $
 */
#include "OTconfig.hxx"
#include "OTconfigureArgs.hxx"
#include "OSS.hxx"
#include "PlatformInfo.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      int PlatformInfo::Precision_ = 6;

      String PlatformInfo::GetVersion()  { return PACKAGE_VERSION; }
      String PlatformInfo::GetName()     { return PACKAGE_NAME;    }
      String PlatformInfo::GetRevision() { return Revision; }
      String PlatformInfo::GetDate()     { return ConfigureDate; }
      String PlatformInfo::GetId()       { return "$Id: PlatformInfo.cxx 990 2008-10-29 17:54:45Z dutka $"; }

      String PlatformInfo::GetConfigureCommandLine()
      {
	return ConfigureArgs;
      }

      int    PlatformInfo::GetNumericalPrecision()
      {
	return PlatformInfo::Precision_;
      }

      void   PlatformInfo::SetNumericalPrecision(int precision)
      {
	PlatformInfo::Precision_ = (precision >= 0) ? precision : PlatformInfo::Precision_;
      }

      PlatformInfo::PlatformInfo() : precision_(Precision_)  {}
      PlatformInfo::~PlatformInfo() {}

      String PlatformInfo::getVersion() const  { return PlatformInfo::GetVersion(); }
      String PlatformInfo::getName() const     { return PlatformInfo::GetName(); }
      String PlatformInfo::getRevision() const { return PlatformInfo::GetRevision(); }
      String PlatformInfo::getDate()  const    { return PlatformInfo::GetDate(); }
      String PlatformInfo::getId() const       { return PlatformInfo::GetId(); }

      String PlatformInfo::getConfigureCommandLine() const
      {
	return PlatformInfo::GetConfigureCommandLine();
      }

      int    PlatformInfo::getNumericalPrecision() const
      {
	return PlatformInfo::GetNumericalPrecision();
      }
      
      void   PlatformInfo::setNumericalPrecision(int precision)
      {
	precision_ = (precision >= 0) ? precision : precision_;
      }

      String PlatformInfo::str() const
      {
	return OSS() << "version="      << getVersion()
		     << " name="        << getName()
 		     << " revision="    << getRevision()
 		     << " date="        << getDate()
 		     << " id="          << getId()
		     << " commandline=" << getConfigureCommandLine();
      }

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
