//                                               -*- C++ -*-
/**
 *  @file  PlatformInfo.hxx
 *  @brief The class PlatformInfo gives information about the library
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-09-11 17:38:40 +0200 (mar 11 sep 2007) $
 *  Id:      $Id: PlatformInfo.hxx 506 2007-09-11 15:38:40Z dutka $
 */
#ifndef OPENTURNS_PLATFORMINFO_HXX
#define OPENTURNS_PLATFORMINFO_HXX

#include "OT.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class PlatformInfo
       *
       * PlatformInfo defines methods to query the library about
       * various information (name, version, etc.)
       */

      class PlatformInfo
      {
      private:
	/**
	 * The numerical precision used to write out scientific numbers
	 */
	static int Precision_;

      public:

	static String GetVersion();
	static String GetName();
	static String GetRevision();
	static String GetDate();
	static String GetId();
	static String GetConfigureCommandLine();
	static int    GetNumericalPrecision();
	static void   SetNumericalPrecision(int precision);

      private:

	int precision_;

      public:

	PlatformInfo();  // Required by SWIG
	~PlatformInfo(); // Required by SWIG

	String getVersion() const;
	String getName() const;
	String getRevision() const;
	String getDate() const;
	String getId() const;
	String getConfigureCommandLine() const;
	int    getNumericalPrecision() const;
	void   setNumericalPrecision(int precision);

	String str() const;

      }; /* class PlatformInfo */



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PLATFORMINFO_HXX */
