//                                               -*- C++ -*-
/**
 *  @file  TypedInterfaceObject.hxx
 *  @brief TypedInterfaceObject implements InterfaceObject for a specific class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-22 11:34:11 +0200 (lun 22 sep 2008) $
 *  Id:      $Id: TypedInterfaceObject.hxx 941 2008-09-22 09:34:11Z dutka $
 */
#ifndef OPENTURNS_TYPEDINTERFACEOBJECT_HXX
#define OPENTURNS_TYPEDINTERFACEOBJECT_HXX

#include "InterfaceObject.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class TypedInterfaceObject
       *
       * TypedInterfaceObject implements InterfaceObject for a specific class
       */
      template <class T>
      class TypedInterfaceObject
	: public InterfaceObject
      {
      public:

	typedef InterfaceObject::ImplementationAsPersistentObject   ImplementationAsPersistentObject;
	typedef T                                                   ImplementationType;
	typedef Pointer<ImplementationType>                         Implementation;

	/** Constructor */
	TypedInterfaceObject() {}
	TypedInterfaceObject(const Implementation & impl) : p_implementation_(impl) {}

	/** Returns a pointer to the underlying implementation object */
	inline Implementation & getImplementation() { return p_implementation_; }
	inline const Implementation & getImplementation() const { return p_implementation_; }

#ifndef SWIG
	/** Copy-on-write checker */
	inline void copyOnWrite() { if (!p_implementation_.unique()) p_implementation_.reset(p_implementation_->clone()); }
#endif

	/** Returns a pointer to the underlying implementation object viewed as a PersistentObject */
	inline virtual ImplementationAsPersistentObject getImplementationAsPersistentObject() const { return p_implementation_; }

	/** Sets the pointer to the underlying implementation object */
	inline virtual void setImplementationAsPersistentObject(const ImplementationAsPersistentObject & obj) { p_implementation_.assign(obj); }

	/** This method exchange the two pointed objects */
	inline void swap(TypedInterfaceObject<T> & other) { p_implementation_.swap(other.p_implementation_); }

	/** Name accessor */
	inline virtual void setName(const String & name) { this->copyOnWrite(); p_implementation_->setName(name); }
	inline virtual String getName() const { return p_implementation_->getName(); }

      protected:
	
	/** A pointer to the underlying implementation object */
	Implementation p_implementation_;

      }; /* class TypedInterfaceObject */



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_TYPEDINTERFACEOBJECT_HXX */
