//                                               -*- C++ -*-
/**
 * @file  AnalyticalNumericalMathEvaluationImplementation.hxx
 * @brief The class that implements the composition between numerical
 *        math functions implementations
 *
 * (C) Copyright 2005-2006 EADS
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 */

#ifndef OPENTURNS_ANALYTICALNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_ANALYTICALNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"
#include "muParser.h"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class AnalyticalNumericalMathEvaluationImplementation
       *
       * The class that implement the composition of two numerical math functions implementations.
       */
      class AnalyticalNumericalMathEvaluationImplementation 
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef NumericalMathEvaluationImplementation::NumericalPoint            NumericalPoint;
	typedef NumericalMathEvaluationImplementation::NumericalSample           NumericalSample;
	typedef mu::Parser                                                       Parser;
	typedef Type::Collection<Parser>                                         ParserCollection;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException  InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException         InternalException;
	typedef NumericalMathEvaluationImplementation::StorageManager            StorageManager;
	typedef Type::Collection<NumericalScalar>                                NumericalScalarCollection;

	/** Default constructor */
	AnalyticalNumericalMathEvaluationImplementation();

	/** Default constructor */
	AnalyticalNumericalMathEvaluationImplementation(const Description & inputVariablesNames,
							const Description & outputVariablesNames,
							const Description & formulas)
	  throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual AnalyticalNumericalMathEvaluationImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const AnalyticalNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String str() const;

	/** Operator () */
	using NumericalMathEvaluationImplementation::operator();
	NumericalPoint operator() (const NumericalPoint & in) const
	  throw(InvalidArgumentException, InternalException);

	/** Accessor for input point dimension */
	UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);

      protected:

	/** The function that checks the proper initialization of parsers */
	void checkInitialization() const;

      private:

	mutable NumericalScalarCollection inputVariables_;
	mutable Bool isInitialized_;
	Description inputVariablesNames_;
	Description outputVariablesNames_;
	Description formulas_;
	/** A mathematical expression parser from the muParser library */
	mutable ParserCollection parsers_;

      }; /* class AnalyticalNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ANALYTICALNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
