//                                               -*- C++ -*-
/**
 * @file  ComputedNumericalMathEvaluationImplementationFactory.cxx
 * @brief The class ComputedNumericalMathEvaluationImplementationFactory creates ComputedNumericalMathEvaluationImplementation from external codes
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy: dutka $
 * @date   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 */

#include "OSS.hxx"
#include "WrapperFile.hxx"
#include "Exception.hxx"
#include "ComputedNumericalMathEvaluationImplementationFactory.hxx"
#include "NoNumericalMathEvaluationImplementation.hxx"
#include "Log.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      using OT::Base::Common::NoWrapperFileFoundException;
      using OT::Base::Common::WrapperFileParsingException;
      using OT::Base::Common::WrapperInternalException;
      using OT::Base::Common::Log;

      CLASSNAMEINIT(ComputedNumericalMathEvaluationImplementationFactory);

      /* The unique instance of the Singleton model */
      ComputedNumericalMathEvaluationImplementationFactory::Instance ComputedNumericalMathEvaluationImplementationFactory::P_instance_(0);

      /* Default constructor */
      ComputedNumericalMathEvaluationImplementationFactory::ComputedNumericalMathEvaluationImplementationFactory()
	: NumericalMathEvaluationImplementationFactory()
      {
        // Nothing to do
      }

      /* String converter */
      String ComputedNumericalMathEvaluationImplementationFactory::str() const
      {
	OSS oss;
	oss << "class=" << ComputedNumericalMathEvaluationImplementationFactory::GetClassName();
	return oss;
      }


      /* The accessor to the Singleton element */
      ComputedNumericalMathEvaluationImplementationFactory::Instance ComputedNumericalMathEvaluationImplementationFactory::getInstance()
      {
	if (P_instance_.isNull()) {
	  // this is the first call, we have to create the instance
	  P_instance_.reset(new ComputedNumericalMathEvaluationImplementationFactory);
	}
	return P_instance_;
      }




      /* Object builder */
      NumericalMathEvaluationImplementation * ComputedNumericalMathEvaluationImplementationFactory::buildObject(const String & functionName) const
      {
	FileName wrapperPath;
	NumericalMathEvaluationImplementation * implementation;
	typedef Common::Exception Exception;

	try {
	  // Open the wrapper file and get the name of the library and the names of
	  // the function, its gradient and its hessian if defined
	  // If the gradient or the hessian are not defined, ask for default ones
	  // Then create the actual functions
	  // Get also the data read inside the wrapper file and pass them to the wrapper
	  WrapperFile wrapperFile = WrapperFile::FindWrapperByName( functionName );
#ifdef DEBUG
	  Log::Debug(OSS() << "Successful search of wrapper file located at " << wrapperFile.getDescriptionFilePath() );
#endif

	  implementation = new ComputedNumericalMathEvaluationImplementation( functionName, wrapperFile );

	}
	catch (Exception & ex) {
	  // 	  throw InvalidArgumentException(HERE)
	  // 	    << "Cannot find wrapper file '" << wrapperPath << "' - " << ex.str();
	  implementation = new NoNumericalMathEvaluationImplementation();
	}

	return implementation;
      }




    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
