//                                               -*- C++ -*-
/**
 *  @file  NoNumericalMathGradientImplementation.cxx
 *  @brief Abstract top-level class for all numerical math gradient implementations
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: NoNumericalMathGradientImplementation.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "NoNumericalMathGradientImplementation.hxx"
#include "PersistentObjectFactory.hxx"


namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(NoNumericalMathGradientImplementation);

      static Common::Factory<NoNumericalMathGradientImplementation> RegisteredFactory("NoNumericalMathGradientImplementation");

      /* Default constructor */
      NoNumericalMathGradientImplementation::NoNumericalMathGradientImplementation()
	: NumericalMathGradientImplementation()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NoNumericalMathGradientImplementation * NoNumericalMathGradientImplementation::clone() const
      {
	return new NoNumericalMathGradientImplementation(*this);
      }

      /* Comparison operator */
      Bool NoNumericalMathGradientImplementation::operator ==(const NoNumericalMathGradientImplementation & other) const
      {
	return true;
      }
  
      /* String converter */
      String NoNumericalMathGradientImplementation::str() const {
	OSS oss;
	oss << "class=" << NoNumericalMathGradientImplementation::GetClassName()
	    << " name=" << getName();
	return oss;
      }
  
      /* Test for actual implementation */
      Bool NoNumericalMathGradientImplementation::isActualImplementation() const
      {
	return false;
      }







      /* Here is the interface that all derived class must implement */
	
      /* Gradient method */
      NoNumericalMathGradientImplementation::Matrix NoNumericalMathGradientImplementation::gradient(const NumericalPoint & in) const
	throw(InvalidArgumentException,InternalException)
      {
	callsNumber_++;
	return Matrix();
      }

      /* Accessor for input point dimension */
      UnsignedLong NoNumericalMathGradientImplementation::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	return 0;
      }
      
      /* Accessor for output point dimension */
      UnsignedLong NoNumericalMathGradientImplementation::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	return 0;
      }
      
    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
