//                                               -*- C++ -*-
/**
 *  @file  NumericalMathHessianImplementation.cxx
 *  @brief Abstract top-level class for all distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: NumericalMathHessianImplementation.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "NumericalMathHessianImplementation.hxx"
#include "PersistentObjectFactory.hxx"


namespace OpenTURNS {

  namespace Base {

    namespace Func {

      typedef Common::NotYetImplementedException NotYetImplementedException;

      CLASSNAMEINIT(NumericalMathHessianImplementation);

      static Common::Factory<NumericalMathHessianImplementation> RegisteredFactory("NumericalMathHessianImplementation");

      /* Default constructor */
      NumericalMathHessianImplementation::NumericalMathHessianImplementation()
	: PersistentObject(),
	  callsNumber_(0),
	  description_()
      {
	// Nothing to do
      }

      /* Virtual constructor */
      NumericalMathHessianImplementation * NumericalMathHessianImplementation::clone() const
      {
	return new NumericalMathHessianImplementation(*this);
      }

      /* Comparison operator */
      Bool NumericalMathHessianImplementation::operator ==(const NumericalMathHessianImplementation & other) const
      {
	return true;
      }
  
      /* String converter */
      String NumericalMathHessianImplementation::str() const {
	OSS oss;
	oss << "class=" << NumericalMathHessianImplementation::GetClassName()
	    << " name=" << getName()
	    << " description=" << description_;
	return oss;
      }
  

      /* Description Accessor */
      void NumericalMathHessianImplementation::setDescription(const Description & description)
      {
	description_ = description;
      }


      /* Description Accessor */
      NumericalMathHessianImplementation::Description NumericalMathHessianImplementation::getDescription() const
      {
	return description_;
      }

      /* Test for actual implementation */
      Bool NumericalMathHessianImplementation::isActualImplementation() const
      {
	return true;
      }







      /* Here is the interface that all derived class must implement */
	
      /* Hessian method */
      NumericalMathHessianImplementation::SymmetricTensor NumericalMathHessianImplementation::hessian(const NumericalPoint & in) const
	throw(InvalidArgumentException, InternalException)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Accessor for input point dimension */
      UnsignedLong NumericalMathHessianImplementation::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Accessor for output point dimension */
      UnsignedLong NumericalMathHessianImplementation::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	throw NotYetImplementedException(HERE);
      }

      /* Get the number of calls to operator() */
      UnsignedLong NumericalMathHessianImplementation::getCallsNumber() const
      {
	return callsNumber_;
      }

      /* Method save() stores the object through the StorageManager */
      void NumericalMathHessianImplementation::save(const StorageManager::Advocate & adv) const
      {
	PersistentObject::save(adv);
	adv.writeValue("callsNumber_", callsNumber_);
	adv.writeValue(description_, StorageManager::MemberNameAttribute, "description_");
      }

      /* Method load() reloads the object from the StorageManager */
      void NumericalMathHessianImplementation::load(const StorageManager::Advocate & adv)
      {
	PersistentObject::load(adv);
	String name;
	UnsignedLong value;
	StorageManager::List objList = adv.getList(StorageManager::UnsignedLongEntity);
	for(objList.firstValueToRead(); objList.moreValuesToRead(); objList.nextValueToRead()) {
	  if (objList.readValue(name, value)) {
	    if (name == "callsNumber_") callsNumber_ = value;
	  }
	}
	objList = adv.getList(StorageManager::ObjectEntity);
	objList.readValue(description_, StorageManager::MemberNameAttribute, "description_");
      }

      
    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
