//                                               -*- C++ -*-
/**
 *  @file  NumericalMathHessianImplementationFactory.cxx
 *  @brief The class NumericalMathHessianImplementationFactory creates NumericalMathHessianImplementation from external codes
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: NumericalMathHessianImplementationFactory.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "WrapperFile.hxx"
#include "Exception.hxx"
#include "NumericalMathHessianImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      CLASSNAMEINIT(NumericalMathHessianImplementationFactory);

      /* Default constructor */
      NumericalMathHessianImplementationFactory::NumericalMathHessianImplementationFactory()
      {
        // Nothing to do
      }

      /* String converter */
      String NumericalMathHessianImplementationFactory::str() const
      {
	OSS oss;
	oss << "class=" << NumericalMathHessianImplementationFactory::GetClassName();
	return oss;
      }




      /* Implementation creation */
      NumericalMathHessianImplementationFactory::Implementation NumericalMathHessianImplementationFactory::buildImplementation(const String & functionName) const
	throw(InvalidArgumentException)
      {
	return Implementation(buildObject(functionName));
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
