//                                               -*- C++ -*-
/**
 *  @file  XMLTags.hxx
 *  @brief This file lists all the tags used into the XML files
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-17 14:26:02 +0200 (ven 17 oct 2008) $
 *  Id:      $Id: XMLTags.hxx 974 2008-10-17 12:26:02Z dutka $
 */
#ifndef OPENTURNS_XMLTAGS_HXX
#define OPENTURNS_XMLTAGS_HXX

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {
      /** Tag list */
      const char * const XMLTag_command           = "command";
      const char * const XMLTag_comment           = "comment";
      const char * const XMLTag_computed_gradient = "computed-gradient";
      const char * const XMLTag_data              = "data";
      const char * const XMLTag_description       = "description";
      const char * const XMLTag_external_code     = "external-code";
      const char * const XMLTag_file              = "file";
      const char * const XMLTag_format            = "format";
      const char * const XMLTag_function          = "function";
      const char * const XMLTag_gradient          = "gradient";
      const char * const XMLTag_hessian           = "hessian";
      const char * const XMLTag_id                = "id";
      const char * const XMLTag_in_data_transfer  = "in-data-transfer";
      const char * const XMLTag_library           = "library";
      const char * const XMLTag_mode              = "mode";
      const char * const XMLTag_name              = "name";
      const char * const XMLTag_out_data_transfer = "out-data-transfer";
      const char * const XMLTag_path              = "path";
      const char * const XMLTag_provided          = "provided";
      const char * const XMLTag_regexp            = "regexp";
      const char * const XMLTag_state             = "state";
      const char * const XMLTag_subst             = "subst";
      const char * const XMLTag_type              = "type";
      const char * const XMLTag_unit              = "unit";
      const char * const XMLTag_variable          = "variable";
      const char * const XMLTag_variable_list     = "variable-list";
      const char * const XMLTag_wrap_mode         = "wrap-mode";
      const char * const XMLTag_wrapper           = "wrapper";

      /** Attribute value list */
      const char * const XMLAttr_no               = "no";
      const char * const XMLAttr_yes              = "yes";
      const char * const XMLAttr_in               = "in";
      const char * const XMLAttr_out              = "out";
      const char * const XMLAttr_dynamic_link     = "dynamic-link";
      const char * const XMLAttr_static_link      = "static-link";
      const char * const XMLAttr_fork             = "fork";
      const char * const XMLAttr_files            = "files";
      const char * const XMLAttr_pipe             = "pipe";
      const char * const XMLAttr_arguments        = "arguments";
      const char * const XMLAttr_socket           = "socket";
      const char * const XMLAttr_corba            = "CORBA";
      const char * const XMLAttr_shared           = "shared";
      const char * const XMLAttr_specific         = "specific";

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */


#endif /* OPENTURNS_XMLTAGS_HXX */
