//                                               -*- C++ -*-
/**
 *  @file  Curve.hxx
 *  @brief Curve class for curve plots
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: Curve.hxx 815 2008-05-21 09:21:38Z dutka $
 */
#ifndef OPENTURNS_CURVE_HXX
#define OPENTURNS_CURVE_HXX

#include "DrawableImplementation.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class Curve
       *
       * The class describing a curve plot
       * Instance of Drawable
       */


      class Curve : public DrawableImplementation
      {

	CLASSNAME;

      public:
	
	typedef DrawableImplementation::NumericalSample NumericalSample;
	typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;
	typedef DrawableImplementation::StorageManager           StorageManager;

	/** Default constructor */
	Curve(const String & legend = NoSpecifiedLabel);

	/** Default constructor */
	Curve(const NumericalSample & data,
	      const String & legend = NoSpecifiedLabel);

	/** Constructor with parameters */
	Curve(const NumericalSample & data,
	      const String & color,
	      const String & lineStyle,
	      const UnsignedLong lineWidth,
	      const String & legend = NoSpecifiedLabel)
	  throw(InvalidArgumentException);

	/** String converter */
	String str() const;

	/** Draw method */
	String draw() const;

	/** Clone method */
	Curve * clone() const;

	/** Check fo data validity */
	Bool isValidData(const NumericalSample & data) const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

 	/** Method load() stores the object through the StorageManager */
	void load(const StorageManager::Advocate & adv);

      private:

      }; /* class Curve */

    }/* namespace Graph */

  }/*namespace Base */

}/* namespace OpenTURNS */

#endif /* OPENTURNS_CURVE_HXX */
