//                                               -*- C++ -*-
/**
 *  @file  Drawable.cxx
 *  @brief Abstract top-level class for all Drawable
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: Drawable.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include "Drawable.hxx"
#include "Curve.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      CLASSNAMEINIT(Drawable);

      /* Default constructor */
      Drawable::Drawable():
	Common::TypedInterfaceObject<DrawableImplementation>(Curve(Curve::NumericalSample(1, 2)).clone())
      {
	// Nothing to do
      }
      
      /* Default constructor */
      Drawable::Drawable(const DrawableImplementation & implementation):
	Common::TypedInterfaceObject<DrawableImplementation>(implementation.clone())
      {
	// Nothing to do
      }
      
      /* String converter */
      String Drawable::str() const
      {
	OSS oss;
	oss << "class=" << Drawable::GetClassName()
	    << " name=" << getName()
	    << " implementation=" << getImplementation()->str();
	return oss;
      }

      /* Here is the interface */

      /* Accessor for bounding box of the drawable */
      OT::Base::Type::NumericalPoint Drawable::getBoundingBox() const
      {
	return getImplementation()->getBoundingBox();
      }

      /* Accessor for legend name */
      String Drawable::getLegendName() const
      {
	return getImplementation()->getLegendName();
      }
      
      /* Accessor for legend name */
      void Drawable::setLegendName(const String & legendName)
	throw(InvalidArgumentException)
      {
	getImplementation()->setLegendName(legendName);
      }

      /* Accessor for legend line style */
      String Drawable::getLineStyle() const
      {
	return getImplementation()->getLineStyle();
      }

      /* Accessor for legend point style */
      void Drawable::setLineStyle(const String & lineStyle)
	throw(InvalidArgumentException)
      {
	getImplementation()->setLineStyle(lineStyle);
      }

      /* Accessor for legend point style */
      String Drawable::getPointStyle() const
      {
	return getImplementation()->getPointStyle();
      }

      /* Accessor for legend point style */
      void Drawable::setPointStyle(const String & pointStyle)
	throw(InvalidArgumentException)
      {
	getImplementation()->setPointStyle(pointStyle);
      }

      /* Accessor for legend fill style */
      String Drawable::getFillStyle() const
      {
	return getImplementation()->getFillStyle();
      }

      /* Accessor for legend fill style */
      void Drawable::setFillStyle(const String & fillStyle)
	throw(InvalidArgumentException)
      {
	getImplementation()->setFillStyle(fillStyle);
      }

      /* Accessor for color */
      String Drawable::getColor() const
      {
	return getImplementation()->getColor();
      }

      /* Accessor for color */
      void Drawable::setColor(const String & color)
	throw(InvalidArgumentException)
      {
	getImplementation()->setColor(color);
      }

      /* Accessor for line width */
      UnsignedLong Drawable::getLineWidth() const
      {
	return getImplementation()->getLineWidth();
      }
      
      /* Accessor for line width */
      void Drawable::setLineWidth(const UnsignedLong lineWidth)
	throw(InvalidArgumentException)
      {
	getImplementation()->setLineWidth(lineWidth);
      }

      /* Accessor for pattern */
      String Drawable::getPattern() const
      {
	return getImplementation()->getPattern();
      }

      void Drawable::setPattern(const String style) throw(InvalidArgumentException)
      {
	getImplementation()->setPattern(style);
      }

      /* Accessor for center */
      Drawable::NumericalPoint Drawable::getCenter() const
      {
	return getImplementation()->getCenter();
      }

      void Drawable::setCenter(const NumericalPoint & center)
      {
	getImplementation()->setCenter(center);
      }

      /* Accessor for radius */
      NumericalScalar Drawable::getRadius() const
      {
	return getImplementation()->getRadius();
      }

      void Drawable::setRadius(const NumericalScalar radius)
      {
	getImplementation()->setRadius(radius);
      }
	
      /* Accessor for labels */
      Drawable::Description Drawable::getLabels() const
      {
	return getImplementation()->getLabels();
      }

      void Drawable::setLabels(const Description & labels)
      {
	getImplementation()->setLabels(labels);
      }

      /* Accessor for color palette */
      Drawable::Description Drawable::getPalette() const
      {
	return getImplementation()->getPalette();
      }

      void Drawable::setPalette(const Description & palette)
	throw(InvalidArgumentException)
      {
	getImplementation()->setPalette(palette);
      }

      /* Accessor for origin */
      NumericalScalar Drawable::getOrigin() const
      {
	return getImplementation()->getOrigin();
      }

      void Drawable::setOrigin(const NumericalScalar origin)
      {
	getImplementation()->setOrigin(origin);
      }

      /* Accessor for first coordinate */
      Drawable::NumericalSample Drawable::getX() const
      {
	return getImplementation()->getX();
      }

      void Drawable::setX(const NumericalSample & x)
      {
	getImplementation()->setX(x);
      }
      
      /* Accessor for second coordinate */
      Drawable::NumericalSample Drawable::getY() const
      {
	return getImplementation()->getY();
      }

      void Drawable::setY(const NumericalSample & y)
      {
	getImplementation()->setY(y);
      }
      
      /* Accessor for levels */
      Drawable::NumericalPoint Drawable::getLevels() const
      {
	return getImplementation()->getLevels();
      }

      void Drawable::setLevels(const NumericalPoint & levels)
      {
	getImplementation()->setLevels(levels);
      }
      
      /* Accessor for drawLabels */
      Bool Drawable::getDrawLabels() const
      {
	return getImplementation()->getDrawLabels();
      }

      void Drawable::setDrawLabels(const Bool & drawLabels)
      {
	getImplementation()->setDrawLabels(drawLabels);
      }

      /* Accessor for data */
      Drawable::NumericalSample Drawable::getData() const
      {
	return getImplementation()->getData();
      }

      /* Generate de R commands for plotting  the graphic */
      String Drawable::draw() const
      {
	return getImplementation()->draw();
      }
      
      /* Clean all the temporary data created by draw() method */
      void Drawable::clean() const
      {
	return getImplementation()->clean();
      }
      
      /* Get R point code from key */
      UnsignedLong Drawable::getPointCode(const String key) const
      {
	return getImplementation()->getPointCode(key);
      }

      /* Give the colors name */
      Drawable::Description Drawable::GetValidColors()
      {
	return DrawableImplementation::GetValidColors();
      }

      /* Give the line style names */
      Drawable::Description Drawable::GetValidLineStyles()
      {
	return DrawableImplementation::GetValidLineStyles();
      }

      /* Give the fill style names */
      Drawable::Description Drawable::GetValidFillStyles()
      {
	return DrawableImplementation::GetValidFillStyles();
      }

      /* Give the point style names */
      Drawable::Description Drawable::GetValidPointStyles()
      {
	return DrawableImplementation::GetValidPointStyles();
      }

    } /* namespace Graph */
  } /* namespace Base */
}/* namespace OpenTURNS */
