//                                               -*- C++ -*-
/**
 *  @file  AbdoRackwitz.hxx
 *  @brief AbdoRackwitz is an actual implementation for
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-26 15:05:53 +0200 (lun 26 mai 2008) $
 *  Id:      $Id: AbdoRackwitz.hxx 824 2008-05-26 13:05:53Z dutka $
 */
#ifndef OPENTURNS_ABDORACKWITZ_HXX
#define OPENTURNS_ABDORACKWITZ_HXX

#include "OT.hxx"
#include "NearestPointAlgorithmImplementation.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optimisation
    {

      /**
       * @class AbdoRackwitz
       * AbdoRackwitz is an actual implementation for
       * NearestPointAlgorithm
       */
      class AbdoRackwitz :
	public NearestPointAlgorithmImplementation
      {
	CLASSNAME;
      public:

	typedef NearestPointAlgorithmImplementation::NumericalMathFunction NumericalMathFunction;
	typedef NearestPointAlgorithmImplementation::InternalException     InternalException;
	typedef Type::NumericalPoint                                       NumericalPoint;

#ifndef SWIG
	/**
	 * @class SpecificParameters
	 * Specific parameters of the cobyla library
	 */
	class SpecificParameters
	  : public Common::PersistentObject
	{
	  /* Multiplicative decrease of linear step */
	  static const NumericalScalar DefaultTau;
	  /* Armijo factor */
	  static const NumericalScalar DefaultOmega;
	  /* Growing factor in penalization term */
	  static const NumericalScalar DefaultSmooth;

	  CLASSNAME;
	public:
	  /** Default constructor */
	  SpecificParameters();

	  /** Parameters constructor */
	  SpecificParameters(const NumericalScalar tau,
                             const NumericalScalar omega,
                             const NumericalScalar smooth);
	  
	  /** Virtual constructor */
	  virtual SpecificParameters * clone() const;

	  /** Tau accessor */
	  NumericalScalar getTau() const;

	  /** Tau accessor */
	  void setTau(const NumericalScalar tau);

	  /** Omega accessor */
	  NumericalScalar getOmega() const;

	  /** Omega accessor */
	  void setOmega(const NumericalScalar tau);

	  /** Smooth accessor */
	  NumericalScalar getSmooth() const;

	  /** Smooth accessor */
	  void setSmooth(const NumericalScalar tau);

	  /** String converter */
	  String str() const;

	private:

	  /* Multiplicative decrease of linear step */
	  NumericalScalar tau_;

	  /* Armijo factor */
	  NumericalScalar omega_;

	  /* Growing factor in penalization term */
	  NumericalScalar smooth_;

	}; /* class SpecificParameters */
#else
	typedef OT::Base::Optimisation::AbdoRackwitzSpecificParameters SpecificParameters;
#endif

	/** Default constructor */
	AbdoRackwitz();

	/** Constructor with parameters */
	AbdoRackwitz(const SpecificParameters & specificParameters,
		     const NumericalMathFunction & levelFunction);


	/** Virtual constructor */
	virtual AbdoRackwitz * clone() const;

	/** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
	void run()
	  throw(InternalException);

	/** Specific parameters accessor */
	SpecificParameters getSpecificParameters() const;

	/** Specific parameters accessor */
	void setSpecificParameters(const SpecificParameters & specificParameters);
	/** String converter */
	String str() const;

      private:

	/** Perform a line search in the given direction */
	NumericalScalar computeLineSearch();

	/** Abdo Rackwitz specific parameters */
	SpecificParameters specificParameters_;

	/** Abdo Rackwitz current penalization factor */
	NumericalScalar currentSigma_;

	/** Abdo Rackwitz current point */
	NumericalPoint currentPoint_;

	/** Abdo Rackwitz current direction */
	NumericalPoint currentDirection_;

	/** Abdo Rackwitz current level value */
	NumericalScalar currentLevelValue_;

	/** Abdo Rackwitz current gradient as a column vector */
	NumericalPoint currentGradient_;

	/** Abdo Rackwitz current Lagrange multiplier */
	NumericalScalar currentLambda_;

      }; /* class AbdoRackwitz */

      typedef OpenTURNS::Base::Optimisation::AbdoRackwitz::SpecificParameters  AbdoRackwitzSpecificParameters;

    } /* namespace Optimisation */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ABDORACKWITZ_HXX */
