//                                               -*- C++ -*-
/**
 *  @file  FORM.hxx
 *  @brief FORM implements the First Order Reliability Method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: FORM.hxx 929 2008-09-13 20:37:56Z dutka $
 */
#ifndef OPENTURNS_FORM_HXX
#define OPENTURNS_FORM_HXX

#include "Analytical.hxx"
#include "FORMResult.hxx"

namespace OpenTURNS
{

  namespace Uncertainty
  {

    namespace Algorithm
    {

      /**
       * @class FORM
       * FORM implements the First Order Reliability Method
       * and compute the results of such kind of analyses
       */

      class FORM 
	: public Analytical
      {

	CLASSNAME;
      public:

	typedef Analytical::NumericalPoint        NumericalPoint;
	typedef Analytical::Event                 Event;
	typedef Analytical::Sensitivity           Sensitivity;
	typedef Analytical::NearestPointAlgorithm NearestPointAlgorithm;

	/** Constructor with parameters */
	explicit FORM(const NearestPointAlgorithm & nearestPointAlgorithm,
		      const Event & event,
		      const NumericalPoint & physicalStartingPoint);


	/** Virtual constructor */
	virtual FORM * clone() const;

	/** Result accessor */
	FORMResult getResult() const;

	/** Result accessor */
	void setResult(const FORMResult & result);

	/** String converter */
	String str() const;

	/** Function that computes the design point by re-using the Analytical::run() and creates a FORM::Result */
	void run();

      private:

	FORMResult result_;
      } ; /* class FORM */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FORM_HXX */



