//                                               -*- C++ -*-
/**
 *  @file  Axial.hxx
 *  @brief Axial experiment plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: Axial.hxx 424 2007-05-02 12:59:25Z dutka $
 */
#ifndef OPENTURNS_AXIAL_HXX
#define OPENTURNS_AXIAL_HXX

#include "ExperimentImplementation.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class Axial
       *
       * The class describes the probabilistic concept of axial experiment plan
       */
      class Axial
	: public ExperimentImplementation
      {
	CLASSNAME;
      public:

	typedef ExperimentImplementation::NumericalPoint  NumericalPoint;
	typedef ExperimentImplementation::NumericalSample NumericalSample;

	/** Default constructor */
	explicit Axial(const String & name = OT::DefaultName);

	/** Constructor with parameters */
	explicit Axial(const NumericalPoint & center,
		       const NumericalPoint & levels,
		       const String & name = OT::DefaultName);

	/** Constructor with parameters */
	explicit Axial(const UnsignedLong dimension,
		       const NumericalPoint & levels,
		       const String & name = OT::DefaultName);

	/** Virtual constructor */
	virtual Axial * clone() const;

	/** Experiment plane generation */
	virtual NumericalSample generate();

	/** String converter */
	virtual String str() const;

      }; /* class Axial */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_AXIAL_HXX */
