//                                               -*- C++ -*-
/**
 *  @file  ExperimentImplementation.hxx
 *  @brief Abstract top-level view of an experimentImplementation plane
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: ExperimentImplementation.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX
#define OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX

#include "PersistentObject.hxx"
#include "Pointer.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class ExperimentImplementation
       *
       * The class describes the probabilistic concept of experimentImplementation plan
       */
      class ExperimentImplementation
	: public Base::Common::PersistentObject
      {
	CLASSNAME;
      public:

	typedef Base::Type::NumericalPoint                      NumericalPoint;
	typedef Base::Stat::NumericalSample                     NumericalSample;
	typedef Base::Common::Pointer<ExperimentImplementation> Implementation;

	/** Default constructor */
	explicit ExperimentImplementation(const String & name = OT::DefaultName);

	/** Constructor with parameters */
	explicit ExperimentImplementation(const NumericalPoint & center,
					  const NumericalPoint & levels,
					  const String & name = OT::DefaultName);


	/** Virtual constructor */
	virtual ExperimentImplementation * clone() const = 0;

	/** String converter */
	virtual String str() const;

	/** Center accessor */
	virtual void setCenter(const NumericalPoint & center);

	/** Center accessor */
	virtual NumericalPoint getCenter() const;

	/** Levels accessor */
	virtual void setLevels(const NumericalPoint & levels);

	/** Levels accessor */
	virtual NumericalPoint getLevels() const;

	/* Here is the interface that all derived class must implement */

	/** Sample generation */
	virtual NumericalSample generate();

      protected:

      private:

	NumericalPoint center_;
	NumericalPoint levels_;

      }; /* class ExperimentImplementation */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EXPERIMENTIMPLEMENTATION_HXX */
