//                                               -*- C++ -*-
/**
 *  @file  SafeAndSlow.hxx
 *  @brief Find the roots in a given direction according to the Proban
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: SafeAndSlow.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_SAFEANDSLOW_HXX
#define OPENTURNS_SAFEANDSLOW_HXX

#include "RootStrategyImplementation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class SafeAndSlow
       */

      class SafeAndSlow :
	public RootStrategyImplementation
      {

	CLASSNAME;
      public:

	typedef RootStrategyImplementation::NumericalScalarCollection NumericalScalarCollection;
	typedef RootStrategyImplementation::Solver                    Solver;
	typedef RootStrategyImplementation::NumericalMathFunction     NumericalMathFunction;
	typedef RootStrategyImplementation::InternalException         InternalException;
	typedef RootStrategyImplementation::InvalidDimensionException InvalidDimensionException;

	/** Default constructor */
	explicit SafeAndSlow();

	/** Constructor with parameters */
	SafeAndSlow(const Solver & solver);

	/** Constructor with parameters */
	SafeAndSlow(const Solver & solver,
		    const NumericalScalar maximumDistance,
		    const NumericalScalar stepSize);


	/** Virtual constructor */
	virtual SafeAndSlow * clone() const;
	
	/** Solve gives all the roots found applying the root strategy */
	NumericalScalarCollection solve(const NumericalMathFunction & function,
					const NumericalScalar value);

	/** String converter */
	String str() const;

      private:

      } ; /* class SafeAndSlow */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_SAFEANDSLOW_HXX */
