//                                               -*- C++ -*-
/**
 *  @file  StandardSpaceControlledImportanceSampling.hxx
 *  @brief StandardSpaceControlledImportanceSampling is an implementation of the importance sampling Montex Carlo simulation method
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: StandardSpaceControlledImportanceSampling.hxx 929 2008-09-13 20:37:56Z dutka $
 */
#ifndef OPENTURNS_STANDARDSPACECONTROLLEDIMPORTANCESAMPLING_HXX
#define OPENTURNS_STANDARDSPACECONTROLLEDIMPORTANCESAMPLING_HXX

#include "StandardSpaceSimulation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /**
       * @class StandardSpaceControlledImportanceSampling
       */

      class StandardSpaceControlledImportanceSampling :
	public StandardSpaceSimulation
      {

	CLASSNAME;
      public:

	typedef StandardSpaceSimulation::NumericalSample          NumericalSample;
	typedef StandardSpaceSimulation::InvalidArgumentException InvalidArgumentException;
	typedef StandardSpaceSimulation::StandardEvent            StandardEvent;
	typedef StandardSpaceSimulation::Distribution             Distribution;

	/** Constructor with parameters */
	StandardSpaceControlledImportanceSampling(const AnalyticalResult & AnalyticalResult) throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual StandardSpaceControlledImportanceSampling * clone() const;

	/** String converter */
	String str() const;

      private:

	/** Compute the block sample */
	NumericalSample computeBlockSample();

      } ; /* class StandardSpaceControlledImportanceSampling */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_STANDARDSPACECONTROLLEDIMPORTANCESAMPLING_HXX */
