//                                               -*- C++ -*-
/**
 *  @file  StandardSpaceSimulation.cxx
 *  @brief StandardSpaceSimulation is a generic view of standardSpaceSimulation methods for computing
 * probabilities and related quantities by sampling and estimation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-06-04 11:47:22 +0200 (mer, 04 jun 2008) $
 *  Id:      $Id: StandardSpaceSimulation.cxx 840 2008-06-04 09:47:22Z lebrun $
 */
#include "StandardSpaceSimulation.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {

      /*
       * @class StandardSpaceSimulation
       */

      CLASSNAMEINIT(StandardSpaceSimulation);

      /* Constructor with parameters */
      StandardSpaceSimulation::StandardSpaceSimulation(const AnalyticalResult & analyticalResult)
	: Simulation(analyticalResult.getLimitStateVariable()),
	  analyticalResult_(analyticalResult),
	  standardEvent_(StandardEvent(getEvent())),
	  standardDistribution_(standardEvent_.getImplementation()->getAntecedent()->getDistribution())
      {
	// Compute the probability associated to the analytical result
	controlProbability_ = standardDistribution_.getMarginal(0).computeCDF(-analyticalResult.getHasoferReliabilityIndex());
      }

      /* Analytical result accessor */
      AnalyticalResult StandardSpaceSimulation::getAnalyticalResult() const
      {
	return analyticalResult_;
      }

      /* String converter */
      String StandardSpaceSimulation::str() const
      {
	OSS oss;
	oss << "class=" << StandardSpaceSimulation::GetClassName()
	    << " analyticalResult=" << analyticalResult_;
	return oss;
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
