//                                               -*- C++ -*-
/**
 *  @file  NormalCopulaFactory.cxx
 *  @brief Factory for NormalCopula distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: NormalCopulaFactory.cxx 929 2008-09-13 20:37:56Z dutka $
 */
#include <cmath>
#include "NormalCopulaFactory.hxx"
#include "NormalCopula.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /* Default constructor */
      NormalCopulaFactory::NormalCopulaFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      NormalCopulaFactory * NormalCopulaFactory::clone() const
      {
	return new NormalCopulaFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      NormalCopulaFactory::DistributionImplementation * NormalCopulaFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a NormalCopula distribution from an empty sample";
	return NormalCopula(NormalCopula::GetNormalCorrelationFromSpearmanCorrelation(sample.computeSpearmanCorrelation())).clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
