//                                               -*- C++ -*-
/**
 *  @file  ContinuousDistribution.hxx
 *  @brief Abstract top-level class for Continuous distributions
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: ContinuousDistribution.hxx 929 2008-09-13 20:37:56Z dutka $
 */
#ifndef OPENTURNS_CONTINUOUSDISTRIBUTION_HXX
#define OPENTURNS_CONTINUOUSDISTRIBUTION_HXX

#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class ContinuousDistribution
       *
       * A subclass for Continuous usual distributions.
       */
      class ContinuousDistribution 
	: public UsualDistribution
      {
	static const UnsignedLong DefaultIntegrationNodesNumber = 21;

	CLASSNAME;
      public:

	typedef UsualDistribution::NumericalPoint   NumericalPoint;
	typedef UsualDistribution::NumericalSample  NumericalSample;
	typedef UsualDistribution::CovarianceMatrix CovarianceMatrix;
	typedef UsualDistribution::NumericalPointCollection  NumericalPointCollection;
	typedef UsualDistribution::NumericalPointWithDescriptionCollection  NumericalPointWithDescriptionCollection;

	/** Default constructor */
	explicit ContinuousDistribution(const String & name = OT::DefaultName);


	/** Destructor */
	virtual ~ContinuousDistribution();

	/** Virtual constructor */
	virtual DistributionImplementation * clone() const = 0;

	/** Comparison operator */
	Bool operator ==(const ContinuousDistribution & other) const;

	/** Compute the CDF of Xi | X1, ..., Xi-1. x = Xi, y = (X1,...,Xi-1) */
	NumericalScalar computeConditionalCDF(const NumericalScalar x, const NumericalPoint & y) const;

	/** String converter */
	String str() const;


	/* Methods inherited from upper classes */

	/** Tell if the distribution is Continuous */
	virtual Bool isContinuous() const;

      protected:
    
      private:

      }; /* class ContinuousDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONTINUOUSDISTRIBUTION_HXX */
