//                                               -*- C++ -*-
/**
 *  @file  Copula.cxx
 *  @brief Abstract top-level class for all copulas
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: Copula.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include "Copula.hxx"
#include "IndependentCopula.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      CLASSNAMEINIT(Copula);

      typedef Uncertainty::Distribution::IndependentCopula IndependentCopula;
      
      /* Default constructor */
      Copula::Copula()
	: Distribution(IndependentCopula(1))
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }
      
      /* Constructor from distribution */
      Copula::Copula(const Distribution & distribution)
	: Distribution(distribution)
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }
      
      /* Constructor from implementation */
      Copula::Copula(const DistributionImplementation & implementation,
		     const String & name)
	: Distribution(implementation, name)
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }
      
      /* Constructor from implementation */
      Copula::Copula(const Implementation & p_implementation,
		     const String & name)
	: Distribution(p_implementation, name)
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
