//                                               -*- C++ -*-
/**
 *  @file  t_ComparisonOperator_std.cxx
 *  @brief The test file of class ComparisonOperator for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_ComparisonOperator_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
/* #include "Pointer.hxx" */
#include "ComparisonOperator.hxx"
#include "Less.hxx"
#include "LessOrEqual.hxx"
#include "Equal.hxx"
#include "GreaterOrEqual.hxx"
#include "Greater.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;




int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    //     Pointer<ComparisonOperator> p_operator;

    //     p_operator.reset(new Less);
    //     std::cout << "Less.compare(10,20) = " << p_operator->compare(10,20) << std::endl;
    //     std::cout << "Less.compare(20,20) = " << p_operator->compare(20,20) << std::endl;
    //     std::cout << "Less.compare(30,20) = " << p_operator->compare(30,20) << std::endl;

    //     p_operator.reset(new LessOrEqual);
    //     std::cout << "LessOrEqual.compare(10,20) = " << p_operator->compare(10,20) << std::endl;
    //     std::cout << "LessOrEqual.compare(20,20) = " << p_operator->compare(20,20) << std::endl;
    //     std::cout << "LessOrEqual.compare(30,20) = " << p_operator->compare(30,20) << std::endl;

    //     p_operator.reset(new Equal);
    //     std::cout << "Equal.compare(10,20) = " << p_operator->compare(10,20) << std::endl;
    //     std::cout << "Equal.compare(20,20) = " << p_operator->compare(20,20) << std::endl;
    //     std::cout << "Equal.compare(30,20) = " << p_operator->compare(30,20) << std::endl;

    //     p_operator.reset(new GreaterOrEqual);
    //     std::cout << "GreaterOrEqual.compare(10,20) = " << p_operator->compare(10,20) << std::endl;
    //     std::cout << "GreaterOrEqual.compare(20,20) = " << p_operator->compare(20,20) << std::endl;
    //     std::cout << "GreaterOrEqual.compare(30,20) = " << p_operator->compare(30,20) << std::endl;

    //     p_operator.reset(new Greater);
    //     std::cout << "Greater.compare(10,20) = " << p_operator->compare(10,20) << std::endl;
    //     std::cout << "Greater.compare(20,20) = " << p_operator->compare(20,20) << std::endl;
    //     std::cout << "Greater.compare(30,20) = " << p_operator->compare(30,20) << std::endl;

    ComparisonOperator comparisonOperator;
    ComparisonOperator less = Less();
    std::cout << "Less(10,20) = " << less(10,20) << std::endl;
    std::cout << "Less(20,20) = " << less(20,20) << std::endl;
    std::cout << "Less(30,20) = " << less(30,20) << std::endl;

    ComparisonOperator lessOrEqual = LessOrEqual();
    std::cout << "LessOrEqual(10,20) = " << lessOrEqual(10,20) << std::endl;
    std::cout << "LessOrEqual(20,20) = " << lessOrEqual(20,20) << std::endl;
    std::cout << "LessOrEqual(30,20) = " << lessOrEqual(30,20) << std::endl;

    ComparisonOperator equal = Equal();
    std::cout << "Equal(10,20) = " << equal(10,20) << std::endl;
    std::cout << "Equal(20,20) = " << equal(20,20) << std::endl;
    std::cout << "Equal(30,20) = " << equal(30,20) << std::endl;

    ComparisonOperator greaterOrEqual = GreaterOrEqual();
    std::cout << "GreaterOrEqual(10,20) = " << greaterOrEqual(10,20) << std::endl;
    std::cout << "GreaterOrEqual(20,20) = " << greaterOrEqual(20,20) << std::endl;
    std::cout << "GreaterOrEqual(30,20) = " << greaterOrEqual(30,20) << std::endl;

    ComparisonOperator greater = Greater();
    std::cout << "Greater(10,20) = " << greater(10,20) << std::endl;
    std::cout << "Greater(20,20) = " << greater(20,20) << std::endl;
    std::cout << "Greater(30,20) = " << greater(30,20) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
