//                                               -*- C++ -*-
/**
 *  @file  t_Event_std.cxx
 *  @brief The test file of Event class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
 *  Id:      $Id: t_Event_std.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Event.hxx"
#include "RandomVector.hxx"
#include "CompositeRandomVector.hxx"
#include "Less.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Uncertainty::Model;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();

  try {

    /* We create a numerical point of dimension 1 */
    NumericalPoint point(4);
    const NumericalPoint & ref_point(point);

    point[0] = 101;
    point[1] = 202;
    point[2] = 303;
    point[3] = 404;

    std::cout << "point = " << ref_point << std::endl;



    /* We create a 'constant' RandomVector from the NumericalPoint */
    RandomVector vect(point);
    std::cout << "vect=" << vect << std::endl;

    /* Check standard methods of class RandomVector */
    std::cout << "vect dimension=" << vect.getDimension() << std::endl;
    std::cout << "vect realization (first )=" << vect.getRealization() << std::endl;
    std::cout << "vect sample =" << vect.getNumericalSample(5) << std::endl;

    /* We create a numerical math function */
    NumericalMathFunction myFunction("poutre");

    /* We create a composite random vector */
    RandomVector output(myFunction, vect);

    /* We create an Event from this RandomVector */
    Event myEvent(output, Less(), 50);
    std::cout << "myEvent=" << myEvent << std::endl;

    /* We compute one realization of the event */
    std::cout << "myEvent realization=" << myEvent.getRealization() << std::endl;
    std::cout << "myEvent antecedent realization=" << myEvent.getImplementation()->getAntecedent()->getRealization() << std::endl;

    /* We compute a sample of the event */
    std::cout << "myEvent sample=" << myEvent.getNumericalSample(10) << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
