//                                               -*- C++ -*-
/**
 *  @file  t_Exception_std.cxx
 *  @brief The test file of class Exception for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_Exception_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Exception.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;


template <class EXCEPTION>
ExitCodeValue check()
{
  ExitCodeValue rc = ExitCode::Error;

  try {
    throw EXCEPTION(HERE) << "This is the reason of the exception";
  }
  catch (const EXCEPTION & ex) {
    rc = ExitCode::Success;
  }
  catch (...) {
    rc = ExitCode::Error;
  };

  return rc;
}



int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  ExitCodeValue rc = ExitCode::Success;

  rc |= check< Exception                   >();
  rc |= check< FileNotFoundException       >();
  rc |= check< InternalException           >();
  rc |= check< InvalidArgumentException    >();
  rc |= check< InvalidDimensionException   >();
  rc |= check< NoWrapperFileFoundException >();
  rc |= check< NotYetImplementedException  >();
  rc |= check< OutOfBoundException         >();
  rc |= check< WrapperFileParsingException >();
  rc |= check< WrapperInternalException    >();
  rc |= check< XMLException                >();
  rc |= check< XMLParserException          >();
  rc |= check< DynamicLibraryException     >();

  return rc;
}
