//                                               -*- C++ -*-
/**
 *  @file  t_HypothesisTest_correlation.cxx
 *  @brief The test file of class Test
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_HypothesisTest_correlation.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <iomanip>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "HypothesisTest.hxx"
#include "NumericalSample.hxx"
#include "TestResult.hxx"
#include "NumericalPoint.hxx"
#include "Normal.hxx"
#include "Indices.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::StatTest;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();
  
  UnsignedLong size(100);
  UnsignedLong dim(10);
  CorrelationMatrix R(dim);
  for (UnsignedLong i = 0; i < dim; i++)
    {
      for (UnsignedLong j = 0; j < i; j++)
	{
	  R(i, j) = (i + j + 1.0) / (2.0 * dim);
	}
    }
  NumericalPoint mean(dim, 2.0);
  NumericalPoint sigma(dim, 3.0);
  Normal distribution(mean, sigma, R);
  NumericalSample sample(distribution.getNumericalSample(size));
  NumericalSample sampleX(size, dim - 1);
  NumericalSample sampleY(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleY[i][0] = sample[i][0];
      for (UnsignedLong j = 1; j < dim; j++)
	{
	  sampleX[i][j - 1] = sample[i][j];
	}
    }

  Indices selection(5);
  for (UnsignedLong i = 0; i < 5; i++)
    {
      selection[i] = i;
    }

  Indices selection2(1, 0);

  NumericalSample sampleX0(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleX0[i][0] = sampleX[i][0];
    }
  
  NumericalSample sampleZ(size, 1);
  for (UnsignedLong i = 0; i < size; i++)
    {
      sampleZ[i][0] = sampleY[i][0] * sampleY[i][0];
    }

  // PartialPearson : Independence Pearson test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), PartialPearson performs the Independence Pearson test simultaneously on firstSample[i] and secondSample, for i in the selection. For all i, it is supposed that the couple (firstSample[i] and secondSample) is issued from a gaussian  vector.
  // Probability of the H0 reject zone : 1-0.90

  std::cout << "PartialPearsonXY=" << HypothesisTest::PartialPearson(sampleX, sampleY, selection, 0.90) << std::endl;

  // The three tests must be equal
  std::cout << "PartialPearsonX0Y=" << HypothesisTest::PartialPearson(sampleX, sampleY, selection2, 0.90) << std::endl;
  std::cout << "PearsonX0Y=" << HypothesisTest::Pearson(sampleX0, sampleY, 0.90) << std::endl;
  std::cout << "FullPearsonX0Y=" << HypothesisTest::FullPearson(sampleX0, sampleY, 0.90) << std::endl;

  // FullPearson : Independence Pearson test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), FullPearson performs the Independence Pearson test simultaneously on firstSample[i] and secondSample. For all i, it is supposed that the couple (firstSample[i] and secondSample) is issued from a gaussian  vector.
  // Probability of the H0 reject zone : 1-0.90

  std::cout << "FullPearsonX0Y=" << HypothesisTest::FullPearson(sampleX, sampleY, 0.90) << std::endl;
  std::cout << "FullPearsonYY=" << HypothesisTest::FullPearson(sampleY, sampleY, 0.90) << std::endl;

  // PartialSpearman test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), PartialSpearman performs the Independence Spearman test simultaneously on firstSample[i] and secondSample, for i in the selection.
// Probability of the H0 reject zone : 1-0.90

  // The three tests must be equal
  std::cout << "PartialSpearmanX0Y=" << HypothesisTest::PartialSpearman(sampleX, sampleY, selection2, 0.90) << std::endl;
  std::cout << "SpearmanX0Y=" << HypothesisTest::Spearman(sampleX0, sampleY, 0.90) << std::endl;
  std::cout << "FullSpearmanX0Y=" << HypothesisTest::FullSpearman(sampleX0, sampleY, 0.90) << std::endl;

  std::cout << "PartialSpearmanXY=" << HypothesisTest::PartialSpearman(sampleX, sampleY, selection, 0.90) << std::endl;

// FullSpearman : Spearman test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), FullSpearman performs the Independence Spearman test simultaneously on all firstSample[i] and secondSample.
// Probability of the H0 reject zone : 1-0.90

  std::cout << "FullSpearmanYZ=" << HypothesisTest::FullSpearman(sampleY, sampleZ, 0.90) << std::endl;
  std::cout << "FullSpearmanYY=" << HypothesisTest::FullSpearman(sampleY, sampleY, 0.90) << std::endl;

// Regression test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), PartialRegression performs the Regression test simultaneously on all firstSample[i] and secondSample, for i in the selection. The Regression test tests ifthe regression model between two scalar numerical samples is significant. It is based on the deviation analysis of the regression. The Fisher distribution is used.

// The two tests must be equal
  std::cout << "PartialRegressionX0Y=" << HypothesisTest::PartialRegression(sampleX, sampleY, selection2, 0.90) << std::endl;
  std::cout << "FullRegressionX0Y=" << HypothesisTest::FullRegression(sampleX0, sampleY, 0.90) << std::endl;

  std::cout << "PartialRegressionXY=" << HypothesisTest::PartialRegression(sampleX, sampleY, selection, 0.90) << std::endl;

// Regression test between 2 samples : firstSample of dimension n and secondSample of dimension 1. If firstSample[i] is the numerical sample extracted from firstSample (ith coordinate of each point of the numerical sample), FullRegression performs the Regression test simultaneously on all firstSample[i] and secondSample. The Regression test tests if the regression model between two scalar numerical samples is significant. It is based on the deviation analysis of the regression. The Fisher distribution is used.

  std::cout << "FullRegressionXZ=" << HypothesisTest::FullRegression(sampleX, sampleZ, 0.90) << std::endl;
  std::cout << "FullRegressionZZ=" << HypothesisTest::FullRegression(sampleZ, sampleZ, 0.90) << std::endl;


  return ExitCode::Success;
}
