//                                               -*- C++ -*-
/**
 *  @file  t_Indices_std.cxx
 *  @brief The test file of class Indices for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_Indices_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Indices.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {
    UnsignedLong size(4);
    Indices indices(size, 0);
    for (UnsignedLong i = 0; i < size; i++)
      {
	indices[i] = i;
      }
    std::cout << "indices=" << indices << std::endl;
    std::cout << "are indices valid with bound=" << size << "? " << (indices.check(size)? "true" : "false") << std::endl;
    std::cout << "are indices valid with bound=" << size / 2 << "? " << (indices.check(size / 2)? "true" : "false") << std::endl;
    indices[0] = indices[size-1];
    std::cout << "indices after transformation=" << indices << std::endl;
    std::cout << "are indices valid with bound=" << size << "? " << (indices.check(size)? "true" : "false") << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
