//                                               -*- C++ -*-
/**
 * @file  t_MinMax_computation.cxx
 * @brief The test file of class Box for deterministic MinMax computation
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_MinMax_computation.cxx 862 2008-06-26 11:50:17Z dutka $
 */

#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Box.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Algorithm;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  try {
    // Load the physical model
    NumericalMathFunction model("poutre");
    UnsignedLong inputDimension(model.getInputNumericalPointDimension());
    // Define the reference domaine that will be sampled: an hypercube of side length 2, discretized with 9+2=11 points in each dimension
    NumericalPoint levels(inputDimension);
    levels[0] = 9.;
    levels[1] = 9.;
    levels[2] = 9.;
    levels[3] = 9.;
    Box myPlane(levels);
    NumericalSample sample(myPlane.generate());
    // Then, scale and move the cube to sample around the point of interrest
    NumericalPoint point(inputDimension);
    point[0] = 2.1e11;
    point[1] = 1e3;
    point[2] = 1.5;
    point[3] = 2.e-6;
    sample.scale(0.2 * point);
    sample.translate(point);
    // Compute the model over the sample
    NumericalSample response(model(sample));
    // Compute the min and max values taken by the model
    std::cout << "Min=" << response.getMin()[0] << std::endl;
    std::cout << "Max=" << response.getMax()[0] << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
