//                                               -*- C++ -*-
/**
 *  @file  t_NormalCopulaFactory_std.cxx
 *  @brief The test file of class NormalCopula for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_NormalCopulaFactory_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NormalCopulaFactory.hxx"
#include "NormalCopula.hxx"
#include "Distribution.hxx"
#include "NumericalSample.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Model;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();  

  try {
    UnsignedLong dim(3);
    CorrelationMatrix R(dim);
    for (UnsignedLong i = 0; i < dim; i++)
      {
	for (UnsignedLong j = 0; j < i; j++)
	  {
	    R(i, j) = 0.5 * (1.0 + i) / dim;
	  }
      }
    NormalCopula distribution(R);
    UnsignedLong size(10000);
    NumericalSample sample(distribution.getNumericalSample(size));
    NormalCopulaFactory factory;
    Distribution estimatedDistribution(factory.buildImplementation(sample));
    std::cout << "Distribution          =" << distribution << std::endl;
    std::cout << "Estimated distribution=" << estimatedDistribution << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
