//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_exec_sample.cxx
 *  @brief The test file of class NumericalMathFunction for execution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_NumericalMathFunction_exec_sample.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalSample.hxx"
#include "Description.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    /** Instance creation */
    NumericalMathFunction deviation("poutre_sample");

    Description input(4);
    input[0] = "E";
    input[1] = "F";
    input[2] = "L";
    input[3] = "I";
    Description output(1);
    output[0] = "d";
    Description formula(output.getSize());
    formula[0] = "-F*L^3/(3*E*I)";
    NumericalMathFunction deviation_analytical(input, output, formula);

    UnsignedLong size(10);
    NumericalSample inSample(size, 4);
    for(UnsignedLong i = 0; i < size; i++)
      {
	NumericalScalar fact(1.0 + NumericalScalar(i) / size);
	inSample[i][0] = 210.e9 * fact;
	inSample[i][1] = 1000.0 * fact;
	inSample[i][2] = 1.5 * fact;
	inSample[i][3] = 2.e-6 * fact;
      }


    NumericalSample outSample1(deviation(inSample));
    NumericalSample outSample2(deviation.getEvaluationImplementation()->NumericalMathEvaluationImplementation::operator()(inSample));
    NumericalSample outSample3(deviation_analytical(inSample));
    std::cout << "outSample by sample evaluation=" << outSample1 << std::endl;
    std::cout << "outSample by point evaluation=" << outSample2 << std::endl;
    std::cout << "outSample by analytical function=" << outSample3 << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
