//                                               -*- C++ -*-
/**
 *  @file  t_NumericalMathFunction_sample.cxx
 *  @brief The test file of class NumericalMathFunction with samples
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_NumericalMathFunction_sample.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"

using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {

    // Test basic functionnalities
    //checkClassWithClassName<ComputedNumericalMathEvaluationImplementation>();

    // Test some extra functionnalities
    //checkNameFeature<ComputedNumericalMathEvaluationImplementation>();


    /** Instance creation */
    NumericalMathFunction deviation("poutre");

    NumericalPoint inPoint1(4);
    inPoint1[0] = 210.e9;
    inPoint1[1] = 1000;
    inPoint1[2] = 1.4;
    inPoint1[3] = 2.e-6;

    NumericalPoint inPoint2(4);
    inPoint2[0] = 210.e9;
    inPoint2[1] = 1000;
    inPoint2[2] = 1.5;
    inPoint2[3] = 2.e-6;

    NumericalPoint inPoint3(4);
    inPoint3[0] = 210.e9;
    inPoint3[1] = 1000;
    inPoint3[2] = 1.6;
    inPoint3[3] = 2.e-6;

    NumericalSample inSample(3, deviation.getInputNumericalPointDimension());
    inSample[0] = inPoint1;
    inSample[1] = inPoint2;
    inSample[2] = inPoint3;

    NumericalSample outSample = deviation( inSample );

    std::cout << "deviation sample = " << outSample << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
