//                                               -*- C++ -*-
/**
 *  @file  t_Pointer_cast.cxx
 *  @brief The test file of class Pointer for cast
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_Pointer_cast.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "PersistentObject.hxx"
#include "Pointer.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;

class BaseClass : public PersistentObject
{
public:
  BaseClass(const String & name) : PersistentObject(name)
  {
    std::cout << "BaseClass(const String & name) ("
    	      << getName() << ")" << std::endl;
  }
  BaseClass(const BaseClass & other) : PersistentObject(other)
  {
    std::cout << "BaseClass(const BaseClass & other) ("
     	      << getName() << ")" << std::endl;
  }
  virtual ~BaseClass()
  {
    std::cout << "~BaseClass ("
    	      << getName() << ")" << std::endl;
  }
  virtual void doit() const
  {
    std::cout << "BaseClass::doit ("
    	      << getName() << ")" << std::endl;
  }
  virtual BaseClass * clone() const
  {
    return new BaseClass(*this);
  }
};




class DerivedClass : public BaseClass
{
public:
  explicit DerivedClass(const String & name) : BaseClass(name)
  {
    std::cout << "DerivedClass(const String & name) ("
    	      << getName() << ")" << std::endl;
  }
  explicit DerivedClass(const DerivedClass & other) : BaseClass(other)
  {
    std::cout << "DerivedClass(const String & name) ("
     	      << getName() << ")" << std::endl;
  }
  virtual ~DerivedClass()
  {
    std::cout << "~DerivedClass ("
	      << getName() << ")" << std::endl;
  }
  virtual void doit() const
  {
    std::cout << "DerivedClass::doit ("
    	      << getName() << ")" << std::endl;
  }
  virtual DerivedClass * clone() const
  {
    return new DerivedClass(*this);
  }
};



class NotDerivedClass : public PersistentObject
{
public:
  explicit NotDerivedClass(const String & name) : PersistentObject(name)
  {
  }
  explicit NotDerivedClass(const NotDerivedClass & other) : PersistentObject(other)
  {
  }
  virtual ~NotDerivedClass()
  {
  }
  virtual void doit() const
  {
    std::cout << "NotDerivedClass::doit ("
    	      << getName() << ")" << std::endl;
  }
  virtual NotDerivedClass * clone() const
  {
    return new NotDerivedClass(*this);
  }
};



void functionThatCastPointer(const Pointer<BaseClass> & p_base)
{
  std::cout << "void functionThatCastPointer(const Pointer<BaseClass> & p_base)" << std::endl;
  p_base->doit();
}

Pointer<BaseClass> functionThatReturnPointer(const Pointer<DerivedClass> & p_derived)
{
  std::cout << "Pointer<BaseClass> functionThatReturnPointer(const Pointer<DerivedClass> & p_derived)" << std::endl;
  p_derived->doit();
  return p_derived;
}


int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  {
    /** We create a pointer onto a BaseClass object */
    Pointer<BaseClass> p_base = new BaseClass("B1");
    p_base->doit();

    /** We create a pointer onto a DerivedClass object */
    Pointer<DerivedClass> p_derived = new DerivedClass("D1");
    p_derived->doit();

    /** We create a pointer onto a BaseClass object but we put a DerivedClass object into it */
    p_base = new DerivedClass("D2");
    p_base->doit();


    /** We try to pass a Derived Pointer to a function that except a Base Pointer */
    functionThatCastPointer(p_derived);

    /** We try to get a Base Pointer from a function that except a Derived Pointer */
    p_base = functionThatReturnPointer(p_derived);
    p_base->doit();
  }



  /** Now we try to pass a NotDerived Pointer  to a function that except a Base Pointer */
  /** THIS SHOULD NOT WORK */
  Pointer<NotDerivedClass> p_notderived = new NotDerivedClass("ND1");
  // functionThatCastPointer(p_notderived); // ERROR : cannot convert `NotDerivedClass*' to `BaseClass*' 


  /** We cast a Derived Pointer to a Base Pointer to a Derived Pointer again */
  {
    /** We create a pointer onto a DerivedClass object */
    Pointer<DerivedClass> p_derived = new DerivedClass("D3");
    p_derived->doit();

    /** Then the pointer to a Base class */
    Pointer<BaseClass> p_base(p_derived);
    p_base->doit();

    /** Then again a pointer to a derived class */
    Pointer<DerivedClass> p_rederived;
    p_rederived.assign(p_base);
    p_rederived->doit();    
  }


  /** At last, destructor */

  return ExitCode::Success;
}
