//                                               -*- C++ -*-
/**
 *  @file  t_QuadraticCumul_run.cxx
 *  @brief The test file of class QuadraticCumul for the standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-08-01 16:47:51 +0200 (mer 01 aoû 2007) $
 *  Id:      $Id: t_QuadraticCumul_run.cxx 488 2007-08-01 14:47:51Z dutka $
 */
#include <iostream>
#include <iomanip>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticCumul.hxx"
#include "CorrelationMatrix.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "RandomVector.hxx"
#include "Exception.hxx"
#include "IdentityMatrix.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Algorithm;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  try {


    /* We create a NumericalMathFunction */
    NumericalMathFunction myFunc("TestCompositionRight");
    /* We create a distribution */
    UnsignedLong dim(myFunc.getInputNumericalPointDimension());
    NumericalPoint meanPoint(dim, 0.2);
    NumericalPoint sigma(dim);
    for (UnsignedLong i = 0; i < dim; i++)
      {
	sigma[i] = 0.1 * (i + 1);
      }
    CorrelationMatrix R = IdentityMatrix(dim);
    for (UnsignedLong i = 1; i < dim; i++)
      {
	R(i, i - 1) = 0.25;
      }
    Normal distribution(meanPoint, sigma, R);

    /* We create a distribution-based RandomVector */
    RandomVector X(distribution);
    /* We create a composite RandomVector Y from X and myFunction */
    RandomVector Y(myFunc, X);

    // We create a quadraticCumul algorithm
    QuadraticCumul myQuadraticCumul(Y);
    // We compute the several elements provided by the quadratic cumul algorithm
    std::cout << "First order mean=" << myQuadraticCumul.getMeanFirstOrder() << std::endl;
    std::cout << "Second order mean=" << myQuadraticCumul.getMeanSecondOrder() << std::endl;
    std::cout << "Covariance=" << myQuadraticCumul.getCovariance() << std::endl;
  }

  catch (OT::Base::Common::NotSymmetricDefinitePositiveException & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }
  
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
