//                                               -*- C++ -*-
/**
 *  @file  t_Study_load.cxx
 *  @brief The test file of class Study for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-13 22:37:56 +0200 (sam 13 sep 2008) $
 *  Id:      $Id: t_Study_load.cxx 929 2008-09-13 20:37:56Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Study.hxx"
#include "XMLStorageManager.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Beta.hxx"
#include "Matrix.hxx"
#include "LinearModel.hxx"
#include "NearestPointAlgorithm.hxx"
#include "Simulation.hxx"
#include "Beta.hxx"
#include "ComposedDistribution.hxx"
#include "Exponential.hxx"
#include "Gamma.hxx"
#include "Geometric.hxx"
#include "IndependentCopula.hxx"
#include "KernelSmoothing.hxx"
#include "Logistic.hxx"
#include "LogNormal.hxx"
#include "NormalCopula.hxx"
#include "Uniform.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticCumul.hxx"
#include "FORM.hxx"
#include "SORM.hxx"
#include "UserDefined.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Func;
using namespace OT::Base::Optimisation;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Algorithm;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;

  const char fileName[] = "myXMLFile";

  try {

    // Create a Study Object
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager(fileName));

    myStudy.load();
    std::cout << "Study = " << myStudy    << std::endl;

    // Create a NumericalPoint from the one stored in the Study
    NumericalPoint point;
    myStudy.fillObject(point, "point");

    std::cout << "point = " << point      << std::endl;

    // Create a NumericalSample from the one stored in the Study
    NumericalSample sample;
    myStudy.fillObject(sample, "mySample");

    std::cout << "sample = " << sample      << std::endl;

    //    myStudy.fillObject(sample, 17);

    //    std::cout << "sample = " << sample      << std::endl;

    // Create a Matrix from the one stored in the Study
    Matrix matrix;
    myStudy.fillObject(matrix, "Unnamed");

    std::cout << "matrix = " << matrix << std::endl;

    // Create a LinearModel from the one stored in the Study
    LinearModel linearModel;
    myStudy.fillObject(linearModel, "Unnamed");

    std::cout << "linear model = " << linearModel << std::endl;

    // Create a NearestPointAlgorithm::Result from the one stored in the Study
    NearestPointAlgorithm::Result nearestPointAlgorithmResult;
    myStudy.fillObject(nearestPointAlgorithmResult, "nearestPointAlgorithmResult");

    std::cout << "nearestPointAlgorithmResult = " << nearestPointAlgorithmResult << std::endl;

    // Create a Simulation::Result from the one stored in the Study
    Simulation::Result simulationResult;
    myStudy.fillObject(simulationResult, "simulationResult");

    std::cout << "simulation result = " << simulationResult << std::endl;

    // Create a Beta distribution from the one stored in the Study
    Beta beta;
    myStudy.fillObject(beta, "Beta");

    std::cout << "beta = " << beta << std::endl;

    // Create a Exponential distribution from the one stored in the Study
    Exponential exponential;
    myStudy.fillObject(exponential, "Exponential");

    std::cout << "exponential = " << exponential << std::endl;

    // Create a Gamma distribution from the one stored in the Study
    Gamma gamma;
    myStudy.fillObject(gamma, "Gamma");

    std::cout << "gamma = " << gamma << std::endl;

    // Create a Geometric distribution from the one stored in the Study
    Geometric geometric;
    myStudy.fillObject(geometric, "Geometric");

    std::cout << "geometric = " << geometric << std::endl;

    // Create a IndependentCopula distribution from the one stored in the Study
    IndependentCopula independentCopula;
    myStudy.fillObject(independentCopula, "IndependentCopula");

    std::cout << "independentCopula = " << independentCopula << std::endl;

    // Create a KernelSmoothing algorithm from the one stored in the Study
    KernelSmoothing kernelSmoothing;
    myStudy.fillObject(kernelSmoothing, "KernelSmoothing");

    std::cout << "kernelSmoothing = " << kernelSmoothing << std::endl;

    // Create a Logistic distribution from the one stored in the Study
    Logistic logistic;
    myStudy.fillObject(logistic, "Logistic");

    std::cout << "logistic = " << logistic << std::endl;

    // Create a LogNormal distribution from the one stored in the Study
    LogNormal logNormal;
    myStudy.fillObject(logNormal, "LogNormal");

    std::cout << "logNormal = " << logNormal << std::endl;

    // Create a NormalCopula distribution from the one stored in the Study
    NormalCopula normalCopula;
    myStudy.fillObject(normalCopula, "NormalCopula");

    std::cout << "normalCopula = " << normalCopula << std::endl;

    // Create a Uniform distribution from the one stored in the Study
    Uniform uniform;
    myStudy.fillObject(uniform, "Uniform");

    std::cout << "uniform = " << uniform << std::endl;

    // Create a ComposedDistribution distribution from the one stored in the Study
    ComposedDistribution composedDistribution;
    myStudy.fillObject(composedDistribution, "ComposedDistribution");

    std::cout << "composedDistribution = " << composedDistribution << std::endl;

    // Create a UserDefined distribution from the one stored in the Study
    UserDefined userDefined;
    myStudy.fillObject(userDefined, "UserDefined");

    std::cout << "userDefined = " << userDefined << std::endl;

    // Create an analytical NumericalMathFunction from the one stored in the Study
    NumericalMathFunction analytical;
    myStudy.fillObject(analytical, "analytical"); 

    // Create a QuadraticCumul algorithm from the one stored in the Study
    QuadraticCumul quadraticCumul;
    myStudy.fillObject(quadraticCumul, "quadraticCumul");

    std::cout << "quadraticCumul = " << quadraticCumul << std::endl;

    // Create a FORMResult from the one stored in the Study
    FORMResult formResult;
    myStudy.fillObject(formResult, "formResult");

    std::cout << "formResult = " << formResult << std::endl;

    // Create a SORMResult from the one stored in the Study
    SORMResult sormResult;
    myStudy.fillObject(sormResult, "sormResult");

    std::cout << "sormResult = " << sormResult << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }




  return ExitCode::Success;
}
