//                                               -*- C++ -*-
/**
 *  @file  t_Tensor_std.cxx
 *  @brief The test file of class Tensor for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
 *  Id:      $Id: t_Tensor_std.cxx 995 2008-10-31 10:52:04Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Tensor.hxx"
#include "NumericalPoint.hxx"
#include "Collection.hxx"
#include "Matrix.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  
  /** TEST NUMBER ZERO : DEFAULT CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number zero : default constructor and string converter" << std::endl;
  
  /* Default constructor */
  Tensor tensor0;
  
  /* String converter */
  std::cout << "tensor0 = " << tensor0 << std::endl;
  
  
  /** TEST NUMBER ONE : CONSTRUCTOR WITH SIZE, OPERATOR() AND STRING CONVERTER */
  std::cout << "test number one : constructor with size, operator() and string converter" << std::endl;
  
  /* Constructor with size */
  Tensor tensor1(2,2,3);
  tensor1.setName("tensor1");
  
  /* Check operator() methods */
  tensor1(0,0,0)=1. ;
  tensor1(1,0,0)=2. ;
  tensor1(0,1,0)=3. ;
  tensor1(1,1,0)=4. ;
  tensor1(0,0,1)=5. ;
  tensor1(1,0,1)=6. ;
  tensor1(0,1,1)=7. ;
  tensor1(1,1,1)=8. ;
  tensor1(0,0,2)=9. ;
  tensor1(1,0,2)=10. ;
  tensor1(0,1,2)=11. ;
  tensor1(1,1,2)=12. ;
      
  /* String converter */
  std::cout << "tensor1 = " << tensor1 << std::endl;
  std::cout << "values = " << tensor1(0,0,0) << " ; "
	    << tensor1(1,0,0) << " ; "
	    << tensor1(0,1,0) << " ; "
	    << tensor1(1,1,0) << " ; "
	    << tensor1(0,0,1) << " ; "
	    << tensor1(1,0,1) << " ; "
	    << tensor1(0,1,1) << " ; "
	    << tensor1(1,1,1) << " ; "
	    << tensor1(0,0,2) << " ; "
	    << tensor1(1,0,2) << " ; "
	    << tensor1(0,1,2) << " ; "
	    << tensor1(1,1,2) << std::endl;
  
  
  /** TEST NUMBER TWO : COPY CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number two : copy constructor and string converter" << std::endl;
  
  /* Copy constructor */
  Tensor tensor2(tensor1);
  
  /* String converter */
  std::cout << "tensor2 = " << tensor2 << std::endl;
  
  
  /** TEST NUMBER THREE : GET DIMENSIONS METHODS */
  std::cout << "test number three : get dimensions methods" << std::endl;
  
  /* Get dimension methods */
  std::cout << "tensor1's nbRows = " << tensor1.getNbRows() << std::endl
            << "tensor1's nbColumns = " << tensor1.getNbColumns() << std::endl
	    << "tensor1's nbSheets = " << tensor1.getNbSheets() << std::endl;
	    
	    
    
  /** TEST NUMBER FOUR : ASSIGNMENT METHOD */
  std::cout << "test number four : assignment method" << std::endl;
  
  /* Assignment method */
  Tensor tensor3 ;
  tensor3 = tensor1 ;
  std::cout << "tensor3 = " << tensor3 << std::endl;
  
  
  /** TEST NUMBER FIVE : ISEMPTY METHOD */
  std::cout << "test number five : isEmpty method" << std::endl;
  
  /* Check method isEmpty */
  Tensor tensor5;
  Tensor tensor6;
  std::cout << "tensor1 is empty = " << tensor1.isEmpty() << std::endl
            << "tensor0 is empty = " << tensor0.isEmpty() << std::endl
            << "tensor5 is empty = " << tensor5.isEmpty() << std::endl
            << "tensor6 is empty = " << tensor6.isEmpty() << std::endl;
	    
  /** TEST NUMBER SIX : GETSHEET AND SETSHEET METHODS */
  std::cout << "tensor1 = " << tensor1 << std::endl;
  //  Matrix sheet1(tensor1.getSheet(1));
  std::cout << "tensor1.getSheet(1) = " << tensor1.getSheet(1) << std::endl;
  Matrix sheet2(2,2);
  sheet2(0,0)=0.5;
  sheet2(1,0)=0.6;
  sheet2(0,1)=0.7;
  sheet2(1,1)=0.8;
  std::cout << "sheet2 = " << sheet2 << std::endl;
  tensor1.setSheet(1,sheet2);
  std::cout << "tensor1 = " << tensor1 << std::endl;
    
	    
  return ExitCode::Success;
}
