//                                               -*- C++ -*-
/**
 *  @file  t_TestResult_std.cxx
 *  @brief The test file of class TestResult
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (mer 02 mai 2007) $
 *  Id:      $Id: t_TestResult_std.cxx 424 2007-05-02 12:59:25Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include <cmath>
#include "TestResult.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  
  /** TEST NUMBER ZERO : DEFAULT CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number zero : default constructor and string converter" << std::endl;
  
  /* Default constructor */
  String type = "testResult";
  Bool testBool = 1;
  NumericalScalar testVal = 0.372;
  NumericalScalar testThres = 0.42;
  TestResult testResultTest(type, testBool, testVal, testThres);
  
  /* String converter */
  std::cout << "testResultTest = " << testResultTest << std::endl;
  
  
  /** TEST NUMBER ONE : COPY CONSTRUCTOR AND STRING CONVERTER */
  std::cout << "test number one : copy constructor and string converter" << std::endl;
  
  /* Copy constructor */
  TestResult testResultTest2(testResultTest);
  
  /* String converter */
  std::cout << "testResultTest2 = " << testResultTest2 << std::endl;
  
  
  /** TEST NUMBER TWO : ELEMENTS ACCESSORS */
  std::cout << "test number two : elements accessors" << std::endl;
  std::cout << "testResultTest2 binary quality measure = " << testResultTest2.getBinaryQualityMeasure() << std::endl;
  std::cout << "testResultTest2 p value = " << testResultTest2.getPValue() << std::endl;
  std::cout << "testResultTest2 p value threshold = " << testResultTest2.getThreshold() << std::endl;
  std::cout << "testResultTest2 test type = " << testResultTest2.getTestType() << std::endl;
  
  /** TEST NUMBER THREE : EQUALITY */
  std::cout << "testResultTest2 = testResultTest " << (testResultTest2 == testResultTest) << std::endl;
  String typeDiff = "testResult2";
  Bool testBoolDiff = 0;
  NumericalScalar testValDiff = 0.02;
  NumericalScalar testThresDiff = 0.12;
  TestResult testResultTestDiff(typeDiff, testBoolDiff, testValDiff, testThresDiff);
  std::cout << "testResultTestDiff = testResultTest " << (testResultTestDiff == testResultTest) << std::endl;

	    
  return ExitCode::Success;
}
