//                                               -*- C++ -*-
/**
 *  @file  t_TruncatedDistribution_std.cxx
 *  @brief The test file of class TruncatedDistribution for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_TruncatedDistribution_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include <sstream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "Normal.hxx"
#include "TruncatedNormal.hxx"
#include "TruncatedDistribution.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();

  try {
    Collection<TruncatedNormal> referenceDistribution(2);
    referenceDistribution[0] = TruncatedNormal(2.0, 1.5, 1.0, 4.0);
    referenceDistribution[1] = TruncatedNormal(2.0, 1.5, 1.0, 200.0);
    Collection<TruncatedDistribution> distribution(2);
    distribution[0] = TruncatedDistribution(Normal(2.0, 1.5), 1.0, 4.0);
    distribution[1] = TruncatedDistribution(Normal(2.0, 1.5), 1.0, TruncatedDistribution::LOWER);
    for (UnsignedLong testCase = 0; testCase < 2; ++testCase)
      {
	std::cout << "Distribution " << distribution[testCase] << std::endl;
	
	// Is this distribution elliptical ?
	std::cout << "Elliptical = " << (distribution[testCase].isElliptical() ? "true" : "false") << std::endl;
	
	// Is this distribution continuous ?
	std::cout << "Continuous = " << (distribution[testCase].isContinuous() ? "true" : "false") << std::endl;
	
	// Test for realization of distribution
	NumericalPoint oneRealization = distribution[testCase].getRealization();
	std::cout << "oneRealization=" << oneRealization << std::endl;
	
	// Test for sampling
	UnsignedLong size = 10000;
	NumericalSample oneSample = distribution[testCase].getNumericalSample( size );
	std::cout << "oneSample first=" << oneSample[0] << " last=" << oneSample[size - 1] << std::endl;
	std::cout << "mean=" << oneSample.computeMean() << std::endl;
	std::cout << "covariance=" << oneSample.computeCovariance() << std::endl;
	
	// Define a point
	NumericalPoint point( distribution[testCase].getDimension(), 2.5 );
	std::cout << "Point= " << point << std::endl;
	
	// Show PDF and CDF of point
	NumericalPoint DDF = distribution[testCase].computeDDF( point );
	std::cout << "ddf      =" << DDF << std::endl;
	std::cout << "ddf (ref)=" << referenceDistribution[testCase].computeDDF(point) << std::endl;
	NumericalScalar PDF = distribution[testCase].computePDF( point );
	std::cout << "pdf      =" << PDF << std::endl;
	std::cout << "pdf (ref)=" << referenceDistribution[testCase].computePDF(point) << std::endl;
	NumericalScalar CDF = distribution[testCase].computeCDF( point );
	std::cout << "cdf      =" << CDF << std::endl;
	std::cout << "cdf (ref)=" << referenceDistribution[testCase].computeCDF(point) << std::endl;
	NumericalPoint PDFgr = distribution[testCase].computePDFGradient( point );
	std::cout << "pdf gradient      =" << PDFgr << std::endl;
	std::cout << "pdf gradient (ref)=" << referenceDistribution[testCase].computePDFGradient(point) << std::endl;
	NumericalPoint CDFgr = distribution[testCase].computeCDFGradient( point );
	std::cout << "cdf gradient      =" << CDFgr << std::endl;
	std::cout << "cdf gradient (ref)=" << referenceDistribution[testCase].computeCDFGradient(point) << std::endl;
	NumericalPoint quantile = distribution[testCase].computeQuantile( 0.95 );
	std::cout << "quantile      =" << quantile << std::endl;
	std::cout << "quantile (ref)=" << referenceDistribution[testCase].computeQuantile( 0.95 ) << std::endl;
	std::cout << "cdf(quantile)=" << distribution[testCase].computeCDF(quantile) << std::endl;
	NumericalPoint mean = distribution[testCase].getMean();
	std::cout << "mean      =" << mean << std::endl;
	std::cout << "mean (ref)=" << referenceDistribution[testCase].getMean() << std::endl;
	NumericalPoint standardDeviation = distribution[testCase].getStandardDeviation();
	std::cout << "standard deviation      =" << standardDeviation << std::endl;
	std::cout << "standard deviation (ref)=" << referenceDistribution[testCase].getStandardDeviation() << std::endl;
	NumericalPoint skewness = distribution[testCase].getSkewness();
	std::cout << "skewness      =" << skewness << std::endl;
	std::cout << "skewness (ref)=" << referenceDistribution[testCase].getSkewness() << std::endl;
	NumericalPoint kurtosis = distribution[testCase].getKurtosis();
	std::cout << "kurtosis      =" << kurtosis << std::endl;
	std::cout << "kurtosis (ref)=" << referenceDistribution[testCase].getKurtosis() << std::endl;
	CovarianceMatrix covariance = distribution[testCase].getCovariance();
	std::cout << "covariance      =" << covariance << std::endl;
	std::cout << "covariance (ref)=" << referenceDistribution[testCase].getCovariance() << std::endl;
	TruncatedDistribution::NumericalPointWithDescriptionCollection parameters = distribution[testCase].getParametersCollection();
	std::cout << "parameters      =" << parameters << std::endl;
	std::cout << "parameters (ref)=" << referenceDistribution[testCase].getParametersCollection() << std::endl;
	
	// Specific to this distribution
	NumericalScalar lowerBound(distribution[testCase].getLowerBound());
	std::cout << "lowerBound=" << lowerBound << std::endl;
	NumericalScalar upperBound(distribution[testCase].getUpperBound());
	std::cout << "upperBound=" << upperBound << std::endl;
      }
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
