//                                               -*- C++ -*-
/**
 *  @file  t_UniformFactory_std.cxx
 *  @brief The test file of class Uniform for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
 *  Id:      $Id: t_UserDefinedFactory_std.cxx 862 2008-06-26 11:50:17Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "UserDefinedFactory.hxx"
#include "Distribution.hxx"
#include "NumericalSample.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Distribution;
using namespace OT::Uncertainty::Model;


int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  setRandomGenerator();  

  try {
    NumericalSample sample(3, 2);
    sample[0][0] = 1.0;
    sample[0][1] = 1.5;
    sample[1][0] = 2.0;
    sample[1][1] = 2.5;
    sample[2][0] = 3.0;
    sample[2][1] = 3.5;
    UserDefinedFactory factory;
    Distribution estimatedDistribution(factory.buildImplementation(sample));
    std::cout << "Sample                =" << sample << std::endl;
    std::cout << "Estimated distribution=" << estimatedDistribution << std::endl;
  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
