// SWIG file AbdoRackwitz.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2007-04-04 18:49:00 +0200 (mer 04 avr 2007) $
// Id : $Id: AbdoRackwitz.i 407 2007-04-04 16:49:00Z dutka $

%{
#include "AbdoRackwitz.hxx"
%}

%include AbdoRackwitz.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * @class AbdoRackwitzSpecificParameters
 * Specific parameters of the cobyla library
 */
class AbdoRackwitzSpecificParameters: public
  OpenTURNS::Base::Common::PersistentObject
{
  /* Multiplicative decrease of linear step */
  static const NumericalScalar DEFAULT_TAU;
  /* Armijo factor */
  static const NumericalScalar DEFAULT_OMEGA;
  /* Growing factor in penalization term */
  static const NumericalScalar DEFAULT_SMOOTH;

  CLASSNAME;
public:
  /* Default constructor */
  AbdoRackwitzSpecificParameters();

  /* Parameters constructor */
  AbdoRackwitzSpecificParameters(const NumericalScalar tau, const NumericalScalar omega, const NumericalScalar smooth);

  /* Copy constructor */
  AbdoRackwitzSpecificParameters(const AbdoRackwitzSpecificParameters & other);

  /* Virtual constructor */
  virtual AbdoRackwitzSpecificParameters * clone() const;

  /* Destructor */
  virtual ~AbdoRackwitzSpecificParameters();

  /* Tau accessor */
  NumericalScalar getTau() const;

  /* Tau accessor */
  void setTau(const NumericalScalar tau);

  /* Omega accessor */
  NumericalScalar getOmega() const;

  /* Omega accessor */
  void setOmega(const NumericalScalar tau);

  /* Smooth accessor */
  NumericalScalar getSmooth() const;

  /* Smooth accessor */
  void setSmooth(const NumericalScalar tau);

  /* String converter */
  String str() const;

}; /* class AbdoRackwitzSpecificParameters */

}}}
namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend AbdoRackwitz { AbdoRackwitz(const AbdoRackwitz & other) { return new OpenTURNS::Base::Optimisation::AbdoRackwitz(other); } } }}}
