// SWIG file BoundConstrainedAlgorithmImplementation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
// Id : $Id: BoundConstrainedAlgorithmImplementation.i 995 2008-10-31 10:52:04Z dutka $

%{
#include "BoundConstrainedAlgorithmImplementation.hxx"
%}

%include BoundConstrainedAlgorithmImplementation.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * Result stores the optimization result 
 */
class BoundConstrainedAlgorithmImplementationResult: public
 OpenTURNS::Base::Common::PersistentObject
{
public:
		
  /* Default constructor */
  explicit BoundConstrainedAlgorithmImplementationResult();

  /* Standard constructor */
  BoundConstrainedAlgorithmImplementationResult(const Type::NumericalPoint & optimizer,
         const NumericalScalar optimalValue,
	 const BoundConstrainedAlgorithmImplementation::OptimizationProblem optimization,
	 const UnsignedLong evaluationsNumber,
	 const NumericalScalar absoluteError,
	 const NumericalScalar relativeError,
	 const NumericalScalar objectiveError,
	 const NumericalScalar constraintError);


  /* Copy constructor */
  BoundConstrainedAlgorithmImplementationResult(const BoundConstrainedAlgorithmImplementationResult & other);

  /* Virtual constructor */
  virtual BoundConstrainedAlgorithmImplementationResult * clone() const;

  /* Optimizer accessors */
  Type::NumericalPoint getOptimizer() const;

  /* Optimal value accessor */
  NumericalScalar getOptimalValue() const;

  /* Optimization problem accessor */
  BoundConstrainedAlgorithmImplementation::OptimizationProblem getOptimizationProblem() const;

  /* Iterations number accessor */
  UnsignedLong getEvaluationsNumber() const;

  /* Absolute error accessor */
  NumericalScalar getAbsoluteError() const;

  /* Relative error accessor */
  NumericalScalar getRelativeError() const;

  /* Objective error accessor */
  NumericalScalar getObjectiveError() const;

  /* Constraint error accessor */
  NumericalScalar getConstraintError() const;

  /* String converter */
  virtual String str() const;

}; // class BoundConstrainedAlgorithmImplementationResult

%extend BoundConstrainedAlgorithmImplementationResult {
  const String __str__() const { return self->str(); }
}

}}}

namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend BoundConstrainedAlgorithmImplementation { BoundConstrainedAlgorithmImplementation(const BoundConstrainedAlgorithmImplementation & other) { return new OpenTURNS::Base::Optimisation::BoundConstrainedAlgorithmImplementation(other); } } }}}
