// SWIG file NearestPointAlgorithmImplementation.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
// Id : $Id: NearestPointAlgorithmImplementation.i 995 2008-10-31 10:52:04Z dutka $

%{
#include "NearestPointAlgorithmImplementation.hxx"
%}

%include NearestPointAlgorithmImplementation.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
/*
 * @class NearestPointAlgorithmImplementationResult
 * NearestPointAlgorithmImplementationResult stores the optimization result 
 */
class NearestPointAlgorithmImplementationResult: public
  OpenTURNS::Base::Common::PersistentObject
{
public:

  /* Default constructor */
  explicit NearestPointAlgorithmImplementationResult();

  /* Standard constructor */
  NearestPointAlgorithmImplementationResult(const Type::NumericalPoint & minimizer,
                                            const UnsignedLong iterationsNumber,
                                            const NumericalScalar absoluteError,
                                            const NumericalScalar relativeError,
                      	                    const NumericalScalar residualError,
              	                            const NumericalScalar constraintError);

  /* Copy constructor */
  NearestPointAlgorithmImplementationResult(const NearestPointAlgorithmImplementationResult & other);

  /* Virtual constructor */
  virtual NearestPointAlgorithmImplementationResult * clone() const;

  /* Destructor */
  virtual ~NearestPointAlgorithmImplementationResult();

  /* Minimizer accessors */
  Type::NumericalPoint getMinimizer() const;

  /* Iterations number accessor */
  UnsignedLong getIterationsNumber() const;

  /* Absolute error accessor */
  NumericalScalar getAbsoluteError() const;

  /* Relative error accessor */
  NumericalScalar getRelativeError() const;

  /* Residual error accessor */
  NumericalScalar getResidualError() const;

  /* Constraint error accessor */
  NumericalScalar getConstraintError() const;

  /* String converter */
  String str() const;

}; // class NearestPointAlgorithmImplementationResult

%extend NearestPointAlgorithmImplementationResult {
  const String __str__() const { return self->str(); }
}

}}}

namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend NearestPointAlgorithmImplementation { NearestPointAlgorithmImplementation(const NearestPointAlgorithmImplementation & other) { return new OpenTURNS::Base::Optimisation::NearestPointAlgorithmImplementation(other); } } }}}
