// SWIG file OTtypes.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-05-21 11:21:38 +0200 (mer 21 mai 2008) $
// Id : $Id: OTtypes.i 815 2008-05-21 09:21:38Z dutka $

%module types

%include std_string.i
%include std_map.i
%include std_complex.i

%include OT.hxx
%include OTtypes.hxx

%inline %{
#include "OT.hxx"
%}

typedef OpenTURNS::String            String;
typedef OpenTURNS::Bool              Bool;
typedef OpenTURNS::NumericalScalar   NumericalScalar;
typedef OpenTURNS::NumericalComplex  NumericalComplex;
typedef OpenTURNS::Id                Id;
typedef OpenTURNS::PointInSourceFile PointInSourceFile;

%typemap(in) NumericalScalar {
  $1 = PyFloat_AsDouble($input);
}

%typemap(in) NumericalComplex {
  $1 = Complex(PyFloat_AsDouble($input.real()), PyFloat_AsDouble($input.imag()));
}

%typemap(out) NumericalComplex {
    $result = complex(PyFloat_FromDouble($1.real()), PyFloat_FromDouble($1.imag()));
}
