//                                               -*- C++ -*-
/**
 * @file  PythonNumericalMathEvaluationImplementation.cxx
 * @brief This class binds a Python function to an Open TURNS' NumericalMathFunction
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: dutka $
 * \date   $LastChangedDate: 2008-10-15 17:56:07 +0200 (mer 15 oct 2008) $
 */

#include "PythonNumericalMathEvaluationImplementation.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      CLASSNAMEINIT(PythonNumericalMathEvaluationImplementation);

      /* Default constructor */
      PythonNumericalMathEvaluationImplementation::PythonNumericalMathEvaluationImplementation(PyObject * pyCallable)
	: NumericalMathEvaluationImplementation(),
	  pyObj_(pyCallable)
      {
	Py_XINCREF( pyCallable );
      }

      /* Virtual constructor */
      PythonNumericalMathEvaluationImplementation * PythonNumericalMathEvaluationImplementation::clone() const
      {
	return new PythonNumericalMathEvaluationImplementation(*this);
      }

      /* Copy constructor */
      PythonNumericalMathEvaluationImplementation::PythonNumericalMathEvaluationImplementation(const PythonNumericalMathEvaluationImplementation & other)
	: NumericalMathEvaluationImplementation(other),
	  pyObj_(other.pyObj_)
      {
	Py_XINCREF( pyObj_ );
      }

      /* Destructor */
      PythonNumericalMathEvaluationImplementation::~PythonNumericalMathEvaluationImplementation()
      {
	Py_XDECREF( pyObj_ );
      }

      /* Comparison operator */
      Bool PythonNumericalMathEvaluationImplementation::operator ==(const PythonNumericalMathEvaluationImplementation & other) const
      {
	return true;
      }
  
      /* String converter */
      String PythonNumericalMathEvaluationImplementation::str() const {
	OSS oss;
	oss << "class=" << PythonNumericalMathEvaluationImplementation::GetClassName()
	    << " name=" << getName();
	return oss;
      }
  
      /* Test for actual implementation */
      Bool PythonNumericalMathEvaluationImplementation::isActualImplementation() const
      {
	return true;
      }






      /* Here is the interface that all derived class must implement */
	
      /* Operator () */
      PythonNumericalMathEvaluationImplementation::NumericalPoint PythonNumericalMathEvaluationImplementation::operator() (const NumericalPoint & in) const
	throw(InvalidArgumentException,InternalException)
      {
	callsNumber_++;

	PyObject * inTuple = PyTuple_New( in.getSize() );
	for(UnsignedLong i=0; i<in.getSize(); ++i) {
	  PyTuple_SetItem( inTuple, i, PyFloat_FromDouble( in[i] ) );
	}

	PyObject * result = PyObject_CallFunction( pyObj_,
						   const_cast<char *>( "(O)" ),
						   inTuple );

	NumericalPoint out;

	if ( PySequence_Check( result ) ) {
	  long length = PySequence_Size( result );
	  out         = NumericalPoint( length );
	  for(long i=0; i<length; ++i) {
	    out[i] = PyFloat_AsDouble( PySequence_GetItem( result, i ) );
	  }
	}

	Py_XDECREF( inTuple );
	Py_XDECREF( result  );

	return out;
      }

      /* Accessor for input point dimension */
      UnsignedLong PythonNumericalMathEvaluationImplementation::getInputNumericalPointDimension() const
	throw(InternalException)
      {
	PyObject * result = PyObject_CallMethod( pyObj_,
						 const_cast<char *>( "getInputNumericalPointDimension" ),
						 const_cast<char *>( "()"                              ) );
	UnsignedLong dim = PyLong_AsLong( result );
	Py_DECREF( result );
	return dim;
      }
      
      /* Accessor for output point dimension */
      UnsignedLong PythonNumericalMathEvaluationImplementation::getOutputNumericalPointDimension() const
	throw(InternalException)
      {
	PyObject * result = PyObject_CallMethod( pyObj_,
						 const_cast<char *>( "getOutputNumericalPointDimension" ), 
						 const_cast<char *>( "()"                               ) );
	UnsignedLong dim = PyLong_AsLong( result );
	Py_DECREF( result );
	return dim;
      }
      
    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
