// SWIG file TNC.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-31 11:52:04 +0100 (ven 31 oct 2008) $
// Id : $Id: TNC.i 995 2008-10-31 10:52:04Z dutka $

%{
#include "TNC.hxx"
%}

%include TNC.hxx

namespace OpenTURNS { namespace Base { namespace Optimisation {
	/*
	 * @class TNCSpecificParameters
	 * Specific parameters of the TNC library
	 */
	class TNCSpecificParameters
	  : public OpenTURNS::Base::Common::PersistentObject
	{
	  static const UnsignedLong    DefaultMaxCGit;
	  static const NumericalScalar DefaultEta;
	  static const NumericalScalar DefaultStepmx;
	  static const NumericalScalar DefaultAccuracy;
	  static const NumericalScalar DefaultFmin;
	  static const NumericalScalar DefaultRescale;

	  CLASSNAME;
	public:
	  /* Default constructor */
	  TNCSpecificParameters();

	  /* Parameters constructor */
	  TNCSpecificParameters(const Type::NumericalPoint & scale,
			     const Type::NumericalPoint & offset,
			     const UnsignedLong    maxCGit,
			     const NumericalScalar eta,
			     const NumericalScalar stepmx,
			     const NumericalScalar accuracy,
			     const NumericalScalar fmin,
			     const NumericalScalar rescale);

	  /* Copy constructor */
	  TNCSpecificParameters(const TNCSpecificParameters & other);

	  /* Virtual constructor */
	  virtual TNCSpecificParameters * clone() const;

	  /* Scale accessor */
	  Type::NumericalPoint getScale() const;
	  void setScale(const Type::NumericalPoint & scale);

	  /* Offset accessor */
	  Type::NumericalPoint getOffset() const;
	  void setOffset(const Type::NumericalPoint & offset);

	  /* MaxCGit accessor */
	  UnsignedLong getMaxCGit() const;
	  void setMaxCGit(const UnsignedLong maxCGit);

	  /* Eta accessor */
	  NumericalScalar getEta() const;
	  void setEta(const NumericalScalar eta);

	  /* Stepmx accessor */
	  NumericalScalar getStepmx() const;
	  void setStepmx(const NumericalScalar stepmx);

	  /* Accuracy accessor */
	  NumericalScalar getAccuracy() const;
	  void setAccuracy(const NumericalScalar accuracy);

	  /* Fmin accessor */
	  NumericalScalar getFmin() const;
	  void setFmin(const NumericalScalar fmin);

	  /* Rescale accessor */
	  NumericalScalar getRescale() const;
	  void setRescale(const NumericalScalar rescale);

	  /* String converter */
	  String str() const;

}; // class TNCSpecificParameters

}}}
namespace OpenTURNS{ namespace Base { namespace Optimisation { %extend TNC { TNC(const TNC & other) { return new OpenTURNS::Base::Optimisation::TNC(other); } } }}}
