// SWIG file UserDefined.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-06-02 15:47:24 +0200 (lun 02 jun 2008) $
// Id : $Id: UserDefined.i 834 2008-06-02 13:47:24Z dutka $

%{
#include "UserDefined.hxx"
%}

%include UserDefined.hxx


namespace OpenTURNS { namespace Uncertainty { namespace Distribution {
class UserDefinedPair: public
  OpenTURNS::Base::Common::PersistentObject{
    CLASSNAME;
  public:
    UserDefinedPair();
    UserDefinedPair(OpenTURNS::Base::Type::NumericalPoint x, NumericalScalar p);
    virtual UserDefinedPair * clone() const;
    ~UserDefinedPair();
    void setX(const OpenTURNS::Base::Type::NumericalPoint & x);
    void setP(const NumericalScalar & p);
    const OpenTURNS::Base::Type::NumericalPoint getX() const;
    const NumericalScalar getP() const;
    /** Method save() stores the object through the StorageManager */
    void save(const OpenTURNS::Base::Common::StorageManager::Advocate & adv) const;

    /** Method load() reloads the object from the StorageManager */
    void load(const OpenTURNS::Base::Common::StorageManager::Advocate & adv);
    
    String str() const;
}; /* end struct Pair */



}}}

%template(UserDefinedPairCollection) OpenTURNS::Base::Type::Collection<OpenTURNS::Uncertainty::Distribution::UserDefinedPair>;
%template(UserDefinedPairPersistentCollection) OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Uncertainty::Distribution::UserDefinedPair>;

namespace OpenTURNS { namespace Uncertainty { namespace Distribution {

%extend UserDefined {
  UserDefined(const OpenTURNS::Base::Type::PersistentCollection<OpenTURNS::Uncertainty::Distribution::UserDefinedPair> & collection)
  {
    return new OpenTURNS::Uncertainty::Distribution::UserDefined(collection);
  }
}

}}}
namespace OpenTURNS { namespace Uncertainty { namespace Distribution { %extend UserDefined { UserDefined(const UserDefined & other) { return new OpenTURNS::Uncertainty::Distribution::UserDefined(other); } } }}}
