#include <Python.h>
#include <dlfcn.h>

#ifndef LIBINSTALL_PATH
#error LIBINSTALL_PATH not defined. Check configuration.
#endif

static PyMethodDef Openturns_PreloadMethods[] = {
  {NULL, NULL, 0, NULL}        /* Sentinel */
};

PyMODINIT_FUNC
initopenturns_preload(void)
{
  PyObject *m;
  void *handle;

  m = Py_InitModule( "openturns_preload", Openturns_PreloadMethods );
  if (m == NULL) {
    PyErr_SetString( PyExc_ImportError, "Initialization of module 'openturns_preload' failed" );
    return;
  }

  dlerror();    /* Clear any existing error */
  handle = dlopen ( LIBINSTALL_PATH "/libOT.so", RTLD_NOW | RTLD_GLOBAL );
  if (!handle) {
    PyErr_SetString( PyExc_IOError, "Dynamic loading of library 'libOT.so' failed at " LIBINSTALL_PATH );
    return;
  }

  dlerror();    /* Clear any existing error */
}
