#                                               -*- Python -*-
#
# @file  Viewer.py
# @brief The viewer of drawing
#
# (C) Copyright 2005-2007 EDF-EADS-Phimeca
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License.
#
# This library is distributed in the hope that it will be useful
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
#
# @author: $LastChangedBy: dutka $
# @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu 26 jun 2008) $
# Id:      $Id: openturns_viewer.py 862 2008-06-26 11:50:17Z dutka $
#
from pydoc import help
from qt import *
from imageviewer import *
from controlwindow import *
from threading import *

class FIFO:
    def __init__(self):
        self.count=0
        self.data=[]
        self.condition=Condition()
        pass

    def push(self,elt):
        self.condition.acquire()
        count=self.count
        self.data.append([count,elt])
        self.count=self.count+1
        self.condition.notify()
        self.condition.release()
        return count

    def pop(self):
        self.condition.acquire()
        while (len(self.data) == 0):
            self.condition.wait()
            pass
        [count,elt]=self.data.pop(0)
        self.condition.release()
        return [count,elt]


class ShowImageEvent(QCustomEvent):
    def __init__(self,num,img):
        QCustomEvent.__init__(self,QEvent.User+10)
        self.num=num
        self.img=img
        pass
    
class MyApp(QObject):
    def __init__(self,mgr,*args):
        QObject.__init__(self)
        self.condition=Condition()
        self.ready=False
        self.args=args
        self.app=None
        self.windows=[]
        self.mgr=mgr
        pass

    def __call__(self):
        self.app=QApplication([])
        self.app.connect(self,PYSIGNAL("doquit()"),
                         self.app,SLOT("quit()"))
        self.app.connect(self,PYSIGNAL("done(number)"), self.mgr.done)
        self.win=ControlWindow()
        self.app.connect(self.win,PYSIGNAL("doquit()"),
                         self.doquit)
        self.app.setMainWidget(self.win)
        self.installEventFilter(self)
        self.win.show()
        self.isReady()
        #print "Before exec_loop()"
        self.app.exec_loop()
        #print "After exec_loop()"
        del self.windows
        del self.args
        del self.win
        del self.app
        pass

    def eventFilter(self,obj,ev):
        aWin=ImageViewer(ev.img)
        self.app.connect(self.win,PYSIGNAL("doclosed()"),
                         aWin.close)
#        aWin.load(ev.img)
        aWin.show()
        self.windows.append(aWin)
        self.emit(PYSIGNAL("done(number)"), (ev.num,))
        return False

    def waitUntilReady(self):
        self.condition.acquire()
        while (not self.ready):
            self.condition.wait()
            pass
        self.condition.release()
        pass

    def isReady(self):
        self.condition.acquire()
        self.ready=True
        self.condition.notify()
        self.condition.release()
        pass

    def doshow(self,num,img):
        ev=ShowImageEvent(num,img)
        QApplication.postEvent(self,ev)
        pass

    def doquit(self):
        self.emit(PYSIGNAL("doquit()"), ())
        pass



class Manager(QObject):
    def __init__(self):
        QObject.__init__(self)
        self.fifo=FIFO()
        self.qtapp=MyApp(self,[])
        self.qtapp.connect(self,PYSIGNAL("doshow(num,img)"),
                           self.qtapp.doshow)
        self.qtapp.connect(self,PYSIGNAL("doquit()"),
                           self.qtapp.doquit)
        self.qtth=Thread(None,self.qtapp)
        self.showed=FIFO()
        pass

    def __call__(self):
        self.qtth.start()
        self.qtapp.waitUntilReady()
        try:
            while 1:
                [number,image]=self.fifo.pop()
                if (image == "Done"):
                    raise "STOP"
                self.emit(PYSIGNAL("doshow(num,img)"), (number,image))
                pass
        except "STOP":
            self.emit(PYSIGNAL("doquit()"), ())
            self.qtth.join()
            del self.qtapp
            del self.fifo
            del self.qtth
            pass
        pass

    def doshow(self,image):
        number=self.fifo.push(image)
        return number

    def done(self,number):
        self.showed.push(number)
        pass

    def stop(self):
        self.fifo.push("Done")
        pass


Mgr=Manager()
viewerThread = Thread(None,Mgr)
viewerThread.setDaemon(True)

def ViewImage(img):
    if (not viewerThread.isAlive()):
        viewerThread.start()
        pass
    return Mgr.doshow(img)

def WaitForViewer(number):
    [c,n]=Mgr.showed.pop()
    while (n != number):
        Mgr.showed.push(n)
        [c,n]=Mgr.showed.pop()
        pass
    pass

def StopViewer():
    Mgr.stop()
    pass
