#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :
    eps = 1e-2
    # Instance creation
    myFunc = NumericalMathFunction("TestResponseSurface")
    print "myFunc (before substitution) = ", myFunc
    epsilon = NumericalPoint(myFunc.getInputNumericalPointDimension(), eps)
    inPoint = NumericalPoint(epsilon.getDimension(), 1.0)
    myGradient = CenteredFiniteDifferenceGradient(epsilon, myFunc.getEvaluationImplementation())

    print "myGradient=" , myGradient
    print "myFunc.gradient(" , inPoint , ")=" , myFunc.gradient(inPoint) 
    print "myGradient.gradient(" , inPoint , ")=" , myGradient.gradient(inPoint)
    
    # Substitute the gradient
    myFunc.setGradientImplementation(myGradient)
    print "myFunc (after substitution) = ", myFunc

#DEBUG ici : segmentaltion fault
    print "myFunc.gradient(" , inPoint , ")=" , myFunc.gradient(inPoint) , " (after substitution)" 

except :
  import sys
  print "t_CenteredFiniteDifferenceGradient_std.py", sys.exc_type, sys.exc_value
